/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp;

import edu.utah.bmi.nlp.Span;
import edu.utah.bmi.nlp.WildCardChecker;
import java.util.ArrayList;

public class SimpleParser {
    protected static final int punctuation = 0;
    protected static final int letter = 1;
    protected static final int digit = 2;
    protected static final int dot = 3;
    protected static final int returnc = 4;

    public static ArrayList<Span> tokenize2Spans(String text, boolean includePunctuation) {
        ArrayList<Span> tokens = new ArrayList<Span>();
        int type = 0;
        int tokenBegin = 0;
        boolean tokenEnd = false;
        boolean sentenceBegin = false;
        boolean sentenceEnd = false;
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char thisChar = text.charAt(i);
            if (WildCardChecker.isPunctuation(thisChar)) {
                if (type > 0) {
                    tokens.add(new Span(tokenBegin, i, tmp.toString()));
                    tmp.setLength(0);
                }
                tokenBegin = i;
                if (includePunctuation) {
                    tokens.add(new Span(tokenBegin, i + 1, String.valueOf(thisChar)));
                }
                type = 0;
                continue;
            }
            if (thisChar == '\n' || thisChar == '\r') {
                if (type > 0) {
                    tokens.add(new Span(tokenBegin, i, tmp.toString()));
                    tmp.setLength(0);
                }
                tokenBegin = i;
                type = 0;
                continue;
            }
            if (Character.isDigit(thisChar)) {
                if (type == 0) {
                    tokenBegin = i;
                    type = 2;
                } else if (type == 1) {
                    tokens.add(new Span(tokenBegin, i, tmp.toString()));
                    tmp.setLength(0);
                    tokenBegin = i;
                    type = 2;
                }
                tmp.append(thisChar);
                continue;
            }
            if (Character.isLetter(thisChar)) {
                if (type == 0) {
                    tokenBegin = i;
                    type = 1;
                } else if (type == 2) {
                    tokens.add(new Span(tokenBegin, i, tmp.toString()));
                    tmp.setLength(0);
                    tokenBegin = i;
                    type = 1;
                }
                tmp.append(thisChar);
                continue;
            }
            if (type != 0) {
                tokens.add(new Span(tokenBegin, i, tmp.toString()));
                tmp.setLength(0);
            }
            type = 0;
        }
        if (type == 1 || type == 2) {
            tokens.add(new Span(tokenBegin, text.length(), text.substring(tokenBegin)));
        }
        return tokens;
    }
}

