/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.rush.core;

import edu.utah.bmi.nlp.Span;
import edu.utah.bmi.rush.core.DeterminantValueSet;
import edu.utah.bmi.rush.core.FastCRules;
import java.util.ArrayList;
import java.util.HashMap;

public class FastCRuleProcessor {
    protected FastCRules fastCRules;

    public FastCRuleProcessor(String ruleFile) {
        this.initiate(ruleFile);
    }

    protected void initiate(String ruleFile) {
        this.fastCRules = new FastCRules(ruleFile);
    }

    public HashMap<DeterminantValueSet.Determinants, ArrayList<Span>> processString(String text, DeterminantValueSet.DirectionPrefer directionPrefer) {
        HashMap<DeterminantValueSet.Determinants, ArrayList<Span>> matchedRules = new HashMap<DeterminantValueSet.Determinants, ArrayList<Span>>();
        matchedRules.clear();
        this.fastCRules.processRules(text, matchedRules, directionPrefer);
        return matchedRules;
    }

    public void setReplicationSupport(boolean support) {
        this.fastCRules.setReplicationSupport(support);
    }

    public void setCompareMethod(String method) {
        this.fastCRules.setCompareMethod(method);
    }

    public void setSpecialCharacterSupport(Boolean scSupport) {
        this.fastCRules.setSpecialCharacterSupport(scSupport);
    }

    public void setDebug(boolean debug) {
        this.fastCRules.setDebug(debug);
    }

    public String getRuleString(int ruleId) {
        return this.fastCRules.getRuleString(ruleId);
    }
}

