/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.rush.core;

import edu.utah.bmi.nlp.Span;
import edu.utah.bmi.nlp.WildCardChecker;
import edu.utah.bmi.rush.core.DeterminantValueSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastCRules {
    protected HashMap<Integer, Double> scores = new HashMap();
    protected HashMap<Integer, String> ruleStore = new HashMap();
    protected int ruleId = 0;
    protected final DeterminantValueSet.Determinants END = DeterminantValueSet.Determinants.END;
    protected final int maxRepeatLength = 100;
    protected boolean supportReplications = false;
    protected boolean scSupport = false;
    protected boolean debug = true;
    protected HashMap rules = new HashMap();
    protected Pattern pdigit;
    protected Matcher mt;
    protected String method = "width";

    protected FastCRules() {
    }

    public FastCRules(String ruleFileName) {
        try {
            this.initiate(ruleFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void initiate(String ruleFile) throws IOException {
        String line = "";
        BufferedReader reader = new BufferedReader(new FileReader(new File(ruleFile)));
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            String[] record = line.split("\\t");
            if (record.length < 3) {
                System.out.println("Illegible rule: " + line);
                continue;
            }
            double score = 0.0;
            if (record.length > 1) {
                score = Double.parseDouble(record[1]);
            }
            String determinant = record[2];
            char[] rule = record[0].toCharArray();
            this.addRule(rule, DeterminantValueSet.Determinants.valueOf(determinant), score);
        }
        reader.close();
    }

    protected boolean addRule(char[] rule, DeterminantValueSet.Determinants determinant, double score) {
        int i;
        HashMap rule1 = this.rules;
        HashMap<Object, Object> rule2 = new HashMap<Object, Object>();
        HashMap rulet = new HashMap();
        int length = rule.length;
        for (i = 0; i < length && rule1 != null && rule1.containsKey(Character.valueOf(rule[i])); rule1 = (HashMap)rule1.get(Character.valueOf(rule[i])), ++i) {
        }
        if (i == length && rule1.containsKey((Object)this.END) && rule1.get((Object)this.END) == determinant) {
            if (this.debug) {
                System.out.println("This rule has been included");
            }
            return false;
        }
        if (i == length) {
            if (rule1.containsKey((Object)this.END)) {
                ((HashMap)rule1.get((Object)this.END)).put(determinant, this.ruleId);
            } else {
                rule2.put((Object)determinant, this.ruleId);
                rule1.put(this.END, rule2.clone());
            }
            this.setScore(this.ruleId, score);
            if (this.debug) {
                this.ruleStore.put(this.ruleId, new String(rule));
            }
            ++this.ruleId;
            return true;
        }
        rule2.put((Object)determinant, this.ruleId);
        rule2.put((Object)this.END, rule2.clone());
        rule2.remove((Object)determinant);
        for (int j = length - 1; j > i; --j) {
            rulet = (HashMap)rule2.clone();
            rule2.clear();
            rule2.put(Character.valueOf(rule[j]), rulet);
        }
        this.setScore(this.ruleId, score);
        if (this.debug) {
            this.ruleStore.put(this.ruleId, new String(rule));
        }
        ++this.ruleId;
        rule1.put(Character.valueOf(rule[i]), rule2.clone());
        return true;
    }

    public void processRules(String text, HashMap<DeterminantValueSet.Determinants, ArrayList<Span>> matches, DeterminantValueSet.DirectionPrefer directionPrefer) {
        char[] textChars = text.toCharArray();
        for (int i = 0; i < textChars.length; ++i) {
            char previousChar = i > 0 ? textChars[i - 1] : (char)' ';
            this.processRules(textChars, this.rules, i, 0, i, matches, directionPrefer, previousChar, false, ' ');
        }
    }

    protected void processRules(char[] textChars, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<DeterminantValueSet.Determinants, ArrayList<Span>> matches, DeterminantValueSet.DirectionPrefer directionPrefer, char previousChar, boolean wildcard, char previousKey) {
        if (currentPosition < textChars.length) {
            char thisChar = textChars[currentPosition];
            if (rule.containsKey(Character.valueOf('\\'))) {
                this.processWildCards(textChars, (HashMap)rule.get(Character.valueOf('\\')), matchBegin, matchEnd, currentPosition, matches, directionPrefer, previousChar);
            }
            if (rule.containsKey(Character.valueOf('('))) {
                this.processRules(textChars, (HashMap)rule.get(Character.valueOf('(')), currentPosition, matchEnd, currentPosition, matches, directionPrefer, previousChar, false, '(');
            }
            if (rule.containsKey(Character.valueOf(')'))) {
                this.processRules(textChars, (HashMap)rule.get(Character.valueOf(')')), matchBegin, currentPosition - 1, currentPosition, matches, directionPrefer, previousChar, false, ')');
            }
            if (rule.containsKey((Object)this.END)) {
                this.addDeterminants(rule, matches, matchBegin, matchEnd, currentPosition, directionPrefer);
            }
            if (this.supportReplications && rule.containsKey(Character.valueOf('+'))) {
                this.processRules(textChars, (HashMap)rule.get(Character.valueOf('+')), matchBegin, matchEnd, currentPosition, matches, directionPrefer, previousChar, false, ' ');
                this.processRepetition(textChars, (HashMap)rule.get(Character.valueOf('+')), matchBegin, matchEnd, currentPosition, matches, directionPrefer, thisChar, wildcard, previousKey);
            }
            if (rule.containsKey(Character.valueOf(thisChar)) && thisChar != ')' && thisChar != '(') {
                this.processRules(textChars, (HashMap)rule.get(Character.valueOf(thisChar)), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, false, thisChar);
            }
        } else if (currentPosition == textChars.length && rule.containsKey((Object)this.END)) {
            this.addDeterminants(rule, matches, matchBegin, matchEnd, currentPosition, directionPrefer);
        } else if (currentPosition == textChars.length && rule.containsKey(Character.valueOf('\\')) && ((HashMap)rule.get(Character.valueOf('\\'))).containsKey(Character.valueOf('e'))) {
            HashMap deterRule = (HashMap)((HashMap)rule.get(Character.valueOf('\\'))).get(Character.valueOf('e'));
            this.addDeterminants(deterRule, matches, matchBegin, matchEnd, currentPosition - 1, directionPrefer);
        } else if (currentPosition == textChars.length && rule.containsKey(Character.valueOf(')'))) {
            HashMap deterRule = (HashMap)rule.get(Character.valueOf(')'));
            if (deterRule.containsKey(Character.valueOf('\\')) && ((HashMap)deterRule.get(Character.valueOf('\\'))).containsKey(Character.valueOf('e'))) {
                this.processRules(textChars, (HashMap)((HashMap)deterRule.get(Character.valueOf('\\'))).get(Character.valueOf('e')), matchBegin, matchEnd, currentPosition, matches, directionPrefer, previousChar, false, ' ');
            }
        } else if (currentPosition == textChars.length && rule.containsKey(Character.valueOf('+'))) {
            HashMap deterRule = (HashMap)rule.get(Character.valueOf('+'));
            this.processRules(textChars, deterRule, matchBegin, matchEnd, currentPosition, matches, directionPrefer, previousChar, wildcard, previousKey);
        }
    }

    protected void processRepetition(char[] textChars, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<DeterminantValueSet.Determinants, ArrayList<Span>> matches, DeterminantValueSet.DirectionPrefer directionPrefer, char previousChar, boolean wildcard, char previousKey) {
        int currentRepeats;
        char thisChar = textChars[currentPosition];
        if (wildcard) {
            switch (previousKey) {
                case 's': {
                    if (thisChar != ' ' && thisChar != '\t' && thisChar != '\u00a0') break;
                    for (currentRepeats = 0; (thisChar == ' ' || thisChar == '\t' || thisChar == '\u00a0') && currentRepeats < 100 && currentPosition < textChars.length - 1; ++currentRepeats) {
                        thisChar = textChars[++currentPosition];
                    }
                    break;
                }
                case 'n': {
                    if (thisChar != '\n' && thisChar != '\r') break;
                    while ((thisChar == '\n' || thisChar == '\r') && currentRepeats < 100 && currentPosition < textChars.length - 1) {
                        ++currentRepeats;
                        thisChar = textChars[++currentPosition];
                    }
                    break;
                }
                case 'd': {
                    if (!Character.isDigit(thisChar)) break;
                    while (Character.isDigit(thisChar) && currentRepeats < 100 && currentPosition < textChars.length - 1) {
                        ++currentRepeats;
                        thisChar = textChars[++currentPosition];
                    }
                    break;
                }
                case 'C': {
                    if (!Character.isUpperCase(thisChar)) break;
                    while (Character.isUpperCase(thisChar) && currentRepeats < 100 && currentPosition < textChars.length - 1) {
                        ++currentRepeats;
                        thisChar = textChars[++currentPosition];
                    }
                    break;
                }
                case 'c': {
                    if (!Character.isLowerCase(thisChar)) break;
                    while (Character.isLowerCase(thisChar) && currentRepeats < 100 && currentPosition < textChars.length - 1) {
                        ++currentRepeats;
                        thisChar = textChars[++currentPosition];
                    }
                    break;
                }
                case 'p': {
                    if (!WildCardChecker.isPunctuation(thisChar)) break;
                    while (WildCardChecker.isPunctuation(thisChar) && currentRepeats < 100 && currentPosition < textChars.length - 1) {
                        ++currentRepeats;
                        thisChar = textChars[++currentPosition];
                    }
                    break;
                }
                case 'a': {
                    if (Character.isWhitespace(thisChar)) break;
                    while (!Character.isWhitespace(thisChar) && currentRepeats < 100 && currentPosition < textChars.length - 1) {
                        ++currentRepeats;
                        thisChar = textChars[++currentPosition];
                    }
                    break;
                }
                case 'u': {
                    if (!WildCardChecker.isSpecialChar(thisChar)) break;
                    while (WildCardChecker.isSpecialChar(thisChar) && currentRepeats < 100 && currentPosition < textChars.length - 1) {
                        ++currentRepeats;
                        thisChar = textChars[++currentPosition];
                    }
                    break;
                }
                case 'w': {
                    if (!Character.isWhitespace(thisChar) && thisChar != '\u00a0' && !WildCardChecker.isSpecialChar(thisChar)) break;
                    while ((Character.isWhitespace(thisChar) || thisChar == '\u00a0' || WildCardChecker.isSpecialChar(thisChar)) && currentRepeats < 100 && currentPosition < textChars.length - 1) {
                        ++currentRepeats;
                        thisChar = textChars[++currentPosition];
                    }
                    break;
                }
            }
        } else if (thisChar == previousKey) {
            while (thisChar == previousKey && currentRepeats < 100 && currentPosition < textChars.length - 1) {
                ++currentRepeats;
                thisChar = textChars[++currentPosition];
            }
        }
        this.processRules(textChars, rule, matchBegin, matchEnd, currentPosition, matches, directionPrefer, previousChar, false, '+');
        if (currentPosition == textChars.length - 1) {
            this.processRules(textChars, rule, matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, previousChar, false, ' ');
        }
    }

    protected void processWildCards(char[] textChars, HashMap rule, int matchBegin, int matchEnd, int currentPosition, HashMap<DeterminantValueSet.Determinants, ArrayList<Span>> matches, DeterminantValueSet.DirectionPrefer directionPrefer, char previousChar) {
        char thisChar = textChars[currentPosition];
        for (Object rulechar : rule.keySet()) {
            char thisRuleChar = ((Character)rulechar).charValue();
            switch (thisRuleChar) {
                case 's': {
                    if (thisChar != ' ' && thisChar != '\t' && thisChar != '\u00a0') break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('s')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, 's');
                    break;
                }
                case 'n': {
                    if (thisChar != '\n' && thisChar != '\r') break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('n')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, 'n');
                    break;
                }
                case '(': {
                    if (thisChar != '(') break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('(')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, '(');
                    break;
                }
                case ')': {
                    if (thisChar != ')') break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf(')')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, ')');
                    break;
                }
                case 'd': {
                    if (!Character.isDigit(thisChar)) break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('d')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, 'd');
                    break;
                }
                case 'C': {
                    if (!Character.isUpperCase(thisChar)) break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('C')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, 'C');
                    break;
                }
                case 'c': {
                    if (!Character.isLowerCase(thisChar)) break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('c')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, 'c');
                    break;
                }
                case 'p': {
                    if (!WildCardChecker.isPunctuation(thisChar)) break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('p')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, 'p');
                    break;
                }
                case '+': {
                    if (thisChar != '+') break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('+')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, '+');
                    break;
                }
                case '\\': {
                    if (thisChar != '\\') break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('\\')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, false, '\\');
                    break;
                }
                case 'b': {
                    if (currentPosition != 0) break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('b')), matchBegin, matchEnd, currentPosition, matches, directionPrefer, previousChar, false, 'b');
                    break;
                }
                case 'a': {
                    if (Character.isWhitespace(thisChar) || thisChar == '\u00a0') break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('a')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, 'a');
                    break;
                }
                case 'u': {
                    if (!WildCardChecker.isSpecialChar(thisChar)) break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('u')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, 'u');
                    break;
                }
                case 'w': {
                    if (!Character.isWhitespace(thisChar) && thisChar != '\u00a0' && !WildCardChecker.isSpecialChar(thisChar)) break;
                    this.processRules(textChars, (HashMap)rule.get(Character.valueOf('w')), matchBegin, matchEnd, currentPosition + 1, matches, directionPrefer, thisChar, true, 'w');
                }
            }
        }
    }

    protected void addDeterminants(HashMap rule, HashMap<DeterminantValueSet.Determinants, ArrayList<Span>> matches, int matchBegin, int matchEnd, int currentPosition, DeterminantValueSet.DirectionPrefer directionPrefer) {
        HashMap deterRule = (HashMap)rule.get((Object)this.END);
        int end = matchEnd == 0 ? currentPosition - 1 : matchEnd;
        Span currentSpan = new Span(matchBegin, end);
        ArrayList<Object> currentSpanList = new ArrayList<Span>();
        for (Object key : deterRule.keySet()) {
            double score;
            int ruleId = (Integer)deterRule.get(key);
            currentSpan.score = score = this.getScore(ruleId);
            currentSpan.ruleId = ruleId;
            if (matches.containsKey(key)) {
                currentSpanList = matches.get(key);
                Span lastSpan = (Span)currentSpanList.get(currentSpanList.size() - 1);
                if (currentSpan.end <= lastSpan.end) {
                    if (currentSpan.end >= lastSpan.begin) continue;
                    currentSpanList.remove(currentSpanList.size() - 1);
                    currentSpanList.add(currentSpan);
                    currentSpanList.add(lastSpan);
                    continue;
                }
                if (lastSpan.end >= currentSpan.begin) {
                    if (lastSpan.begin >= currentSpan.end) {
                        currentSpanList.add(currentSpan);
                        continue;
                    }
                    if (!this.compareSpan(currentSpan, lastSpan)) continue;
                    currentSpanList.remove(currentSpanList.size() - 1);
                }
                currentSpanList.add(currentSpan);
            }
            if (currentSpanList.size() == 0) {
                currentSpanList.add(currentSpan);
            }
            matches.put((DeterminantValueSet.Determinants)((Object)key), currentSpanList);
        }
    }

    public double getScore(int ruleId) {
        return this.scores.get(ruleId);
    }

    public void setScore(int ruleId, double score) {
        this.scores.put(ruleId, score);
    }

    public void setReplicationSupport(boolean support) {
        this.supportReplications = support;
    }

    public void setCompareMethod(String method) {
        this.method = method;
    }

    protected boolean compareScoreOnly(Span a, Span b) {
        if (a.score < 0.0) {
            return true;
        }
        if (b.score < 0.0) {
            return false;
        }
        return a.score > b.score;
    }

    protected boolean compareWidthOnly(Span a, Span b) {
        return a.width > b.width;
    }

    protected boolean compareScorePrior(Span a, Span b) {
        if (a.score < 0.0) {
            return true;
        }
        if (b.score < 0.0) {
            return false;
        }
        if (a.score > b.score) {
            return true;
        }
        return a.score == b.score && a.width > b.width;
    }

    protected boolean compareWidthPrior(Span a, Span b) {
        if (a.width > b.width) {
            return true;
        }
        return a.width == b.width && a.score > b.score;
    }

    protected boolean compareSpan(Span a, Span b) {
        switch (this.method) {
            case "score": {
                return this.compareScoreOnly(a, b);
            }
            case "scorewidth": {
                return this.compareScorePrior(a, b);
            }
            case "widthscore": {
                return this.compareWidthPrior(a, b);
            }
        }
        return this.compareWidthOnly(a, b);
    }

    public void setSpecialCharacterSupport(Boolean scSupport) {
        this.scSupport = scSupport;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getRuleString(int ruleId) {
        if (this.debug && this.ruleStore.containsKey(ruleId)) {
            return this.ruleStore.get(ruleId);
        }
        return "";
    }
}

