/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.rush.core;

import edu.utah.bmi.nlp.Span;
import edu.utah.bmi.rush.core.DeterminantValueSet;
import edu.utah.bmi.rush.core.FastCRuleProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RuSH {
    protected static FastCRuleProcessor fcrp;
    protected static DeterminantValueSet.Determinants begin;
    protected static DeterminantValueSet.Determinants end;
    protected boolean debug = false;

    public RuSH(String rule) {
        this.initiate(rule);
    }

    public void initiate(String rule) {
        fcrp = new FastCRuleProcessor(rule);
        fcrp.setReplicationSupport(true);
        fcrp.setCompareMethod("scorewidth");
        begin = DeterminantValueSet.Determinants.stbegin;
        end = DeterminantValueSet.Determinants.stend;
    }

    public ArrayList<String> segToSentenceStrings(String text) {
        ArrayList<String> output = new ArrayList<String>();
        return output;
    }

    public ArrayList<Span> segToSentenceSpans(String text) {
        ArrayList<Span> output = new ArrayList<Span>();
        HashMap<DeterminantValueSet.Determinants, ArrayList<Span>> result = fcrp.processString(text, DeterminantValueSet.DirectionPrefer.none);
        if (this.debug) {
            text = text.replaceAll("\n", " ");
            for (Map.Entry<DeterminantValueSet.Determinants, ArrayList<Span>> ent : result.entrySet()) {
                System.out.println((Object)ent.getKey());
                for (Span span : ent.getValue()) {
                    System.out.println("\t" + span.begin + "-" + span.end + ":" + span.score + "\t" + text.substring(0, span.begin) + "<" + text.substring(span.begin, span.begin + 1) + ">\t" + span.ruleId + "\t" + fcrp.getRuleString(span.ruleId));
                }
            }
        }
        ArrayList<Span> begins = result.get((Object)begin);
        ArrayList<Span> ends = result.get((Object)end);
        if (begins == null || begins.size() == 0) {
            begins = new ArrayList();
            begins.add(new Span(0, 1, 1, -1.0));
        }
        if (ends == null || ends.size() == 0) {
            ends = new ArrayList();
            ends.add(new Span(text.length() - 1, text.length(), 1, -1.0));
        }
        int stBegin = 0;
        boolean sentenceStarted = false;
        int stEnd = 0;
        int i = 0;
        int j = 0;
        block2: for (i = 0; i < begins.size(); ++i) {
            if (sentenceStarted) continue;
            stBegin = begins.get((int)i).begin;
            if (begins.get((int)i).score == 1.0 || stBegin < stEnd) continue;
            sentenceStarted = true;
            for (int k = j; k < ends.size(); ++k) {
                if (ends.get((int)k).score == 3.0) continue;
                for (stEnd = ends.get((int)k).begin + 1; stEnd >= 1 && (Character.isWhitespace(text.charAt(stEnd - 1)) || text.charAt(stEnd - 1) == '\u00a0'); --stEnd) {
                }
                if (stEnd < stBegin) continue;
                if (sentenceStarted) {
                    output.add(new Span(stBegin, stEnd));
                    sentenceStarted = false;
                    continue block2;
                }
                output.set(output.size() - 1, new Span(stBegin, stEnd));
                sentenceStarted = false;
            }
        }
        return output;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        fcrp.setDebug(debug);
    }

    public void setSpecialCharacterSupport(Boolean scSupport) {
        fcrp.setSpecialCharacterSupport(scSupport);
    }
}

