/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.rush.uima;

import edu.utah.bmi.type.system.Sentence;
import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;

public class RuSHTestAE_General
extends JCasAnnotator_ImplBase {
    protected static int sentenceTypeId = 0;
    public static final String PARAM_SENTENCE_TYPE = "SentenceTypeName";
    public static final String PARAM_PRINT_SPAN = "PrintSpan";
    public static final String PARAM_PRINT_TEXT = "PrintText";
    protected boolean printSpan = true;
    protected boolean printText = false;

    public void initialize(UimaContext cont) {
        String sentenceTypeName = "edu.utah.bmi.type.system.Sentence";
        Object obj = cont.getConfigParameterValue(PARAM_SENTENCE_TYPE);
        if (obj != null) {
            sentenceTypeName = (String)obj;
        }
        if ((obj = cont.getConfigParameterValue(PARAM_PRINT_SPAN)) != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            this.printSpan = false;
        }
        if ((obj = cont.getConfigParameterValue(PARAM_PRINT_TEXT)) != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.printText = true;
        }
        try {
            super.initialize(cont);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sentenceTypeId = this.getTypeId(Class.forName(sentenceTypeName));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        AnnotationIndex annoIndex = jcas.getAnnotationIndex(sentenceTypeId);
        FSIterator annoIter = annoIndex.iterator();
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        while (annoIter.hasNext()) {
            Sentence thisSentence = (Sentence)((Object)annoIter.next());
            sentences.add(thisSentence);
            if (!this.printSpan) continue;
            if (this.printText) {
                System.out.println(thisSentence.getType().getShortName() + "(" + thisSentence.getBegin() + "~" + thisSentence.getEnd() + "):\t" + thisSentence.getCoveredText().replaceAll("\\n", "<\\\\n>"));
                continue;
            }
            System.out.println(thisSentence.getType().getShortName() + ":\t" + thisSentence.getBegin() + "~" + thisSentence.getEnd());
        }
        System.out.println("Total sentences: " + sentences.size());
    }

    public int getTypeId(Class typeClass) {
        int id = 0;
        try {
            id = typeClass.getField("type").getInt(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return id;
    }
}

