/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.rush.uima;

import edu.utah.bmi.nlp.SimpleParser;
import edu.utah.bmi.nlp.Span;
import edu.utah.bmi.nlp.WildCardChecker;
import edu.utah.bmi.rush.core.RuSH;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class RuSH_AE
extends JCasAnnotator_ImplBase {
    protected RuSH seg;
    protected boolean autoFixGaps = true;
    public static final String PARAM_FIX_GAPS = "AutoFixGaps";
    public static final String PARAM_RULE_FILE = "RuleFile";
    public static final String PARAM_SENTENCE_TYPE_NAME = "SentenceTypeName";
    public static final String PARAM_ALTER_SENTENCE_TYPE_NAME = "AlterSentenceTypeName";
    public static final String PARAM_TOKEN_TYPE_NAME = "TokenTypeName";
    public static final String PARAM_INCLUDE_PUNCTUATION = "IncludePunctuation";
    protected Class<? extends Annotation> SentenceType;
    protected Class<? extends Annotation> AlterSentenceType;
    protected Class<? extends Annotation> TokenType;
    protected boolean includePunctuation = false;
    protected boolean differentColoring = false;
    protected boolean colorIndicator = false;
    protected static Constructor<? extends Annotation> SentenceTypeConstructor;
    protected static Constructor<? extends Annotation> AlterSentenceTypeConstructor;
    protected static Constructor<? extends Annotation> TokenTypeConstructor;

    public void initialize(UimaContext cont) {
        String ruleFileName = (String)cont.getConfigParameterValue(PARAM_RULE_FILE);
        this.seg = new RuSH(ruleFileName);
        this.seg.setSpecialCharacterSupport(true);
        Object autoFixGapsObj = cont.getConfigParameterValue(PARAM_FIX_GAPS);
        if (autoFixGapsObj != null) {
            this.autoFixGaps = (Boolean)autoFixGapsObj;
        }
        String alterSentenceTypeName = null;
        String sentenceTypeName = (String)cont.getConfigParameterValue(PARAM_SENTENCE_TYPE_NAME);
        String tokenTypeName = (String)cont.getConfigParameterValue(PARAM_TOKEN_TYPE_NAME);
        Object obj = cont.getConfigParameterValue(PARAM_ALTER_SENTENCE_TYPE_NAME);
        if (obj != null && obj instanceof String && (alterSentenceTypeName = ((String)obj).trim()).length() > 0) {
            this.differentColoring = true;
        }
        if ((obj = cont.getConfigParameterValue(PARAM_INCLUDE_PUNCTUATION)) != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.includePunctuation = true;
        }
        try {
            this.SentenceType = Class.forName(sentenceTypeName).asSubclass(Annotation.class);
            this.TokenType = Class.forName(tokenTypeName).asSubclass(Annotation.class);
            SentenceTypeConstructor = this.SentenceType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            TokenTypeConstructor = this.TokenType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            if (this.differentColoring) {
                this.AlterSentenceType = Class.forName(alterSentenceTypeName).asSubclass(Annotation.class);
                AlterSentenceTypeConstructor = this.AlterSentenceType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String text = jcas.getDocumentText();
        ArrayList<Span> sentences = this.seg.segToSentenceSpans(text);
        int previousEnd = 0;
        for (Span sentence : sentences) {
            int thisBegin = sentence.begin;
            if (this.autoFixGaps) {
                this.fixGap(jcas, text, previousEnd, thisBegin);
            }
            previousEnd = sentence.end;
            ArrayList<Span> tokens = SimpleParser.tokenize2Spans(text.substring(sentence.begin, sentence.end), this.includePunctuation);
            this.saveSentences(jcas, sentence);
            this.saveTokens(jcas, sentence, tokens);
        }
    }

    private void fixGap(JCas jcas, String text, int previousEnd, int thisBegin) {
        int counter = 0;
        int begin = 0;
        int end = 0;
        char[] gapChars = text.substring(previousEnd, thisBegin).toCharArray();
        for (int i = 0; i < thisBegin - previousEnd; ++i) {
            char thisChar = gapChars[i];
            if (Character.isAlphabetic(thisChar) || Character.isDigit(thisChar)) {
                end = i;
                ++counter;
                if (begin != 0) continue;
                begin = i;
                continue;
            }
            if (!WildCardChecker.isPunctuation(thisChar)) continue;
            end = i;
        }
        if (counter > 5) {
            end = end + previousEnd + 1;
            Span sentence = new Span(begin += previousEnd, end);
            ArrayList<Span> tokens = SimpleParser.tokenize2Spans(text.substring(begin, end), this.includePunctuation);
            this.saveSentences(jcas, sentence);
            this.saveTokens(jcas, sentence, tokens);
        }
    }

    protected void saveTokens(JCas jcas, Span sentence, ArrayList<Span> tokens) {
        int sentBegin = sentence.begin;
        for (int i = 0; i < tokens.size(); ++i) {
            Span thisSpan = tokens.get(i);
            this.saveToken(jcas, thisSpan.begin + sentBegin, thisSpan.end + sentBegin);
        }
    }

    protected void saveSentences(JCas jcas, Span sentence) {
        this.saveSentence(jcas, sentence.begin, sentence.end);
    }

    protected void saveToken(JCas jcas, int begin, int end) {
        this.saveAnnotation(jcas, TokenTypeConstructor, begin, end);
    }

    protected void saveSentence(JCas jcas, int begin, int end) {
        if (this.differentColoring) {
            boolean bl = this.colorIndicator = !this.colorIndicator;
            if (!this.colorIndicator) {
                this.saveAnnotation(jcas, AlterSentenceTypeConstructor, begin, end);
                return;
            }
        }
        this.saveAnnotation(jcas, SentenceTypeConstructor, begin, end);
    }

    protected void saveAnnotation(JCas jcas, Constructor<? extends Annotation> annoConstructor, int begin, int end) {
        Annotation anno = null;
        try {
            anno = annoConstructor.newInstance(jcas, begin, end);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        anno.addToIndexes();
    }
}

