/*
  $Id: PKCS12EncryptionScheme.java 1818 2011-02-08 19:19:09Z dfisher $

  Copyright (C) 2007-2011 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1818 $
  Updated: $Date: 2011-02-08 14:19:09 -0500 (Tue, 08 Feb 2011) $
*/
package edu.vt.middleware.crypt.pbe;

import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.pkcs.PBEParameter;
import edu.vt.middleware.crypt.symmetric.SymmetricAlgorithm;

/**
 * Implements the password-based encryption scheme in section B of PKCS#12.
 *
 * @author  Middleware Services
 * @version  $Revision: 1818 $
 */
public class PKCS12EncryptionScheme
  extends AbstractVariableKeySizeEncryptionScheme
{

  /**
   * Creates a new instance with the given parameters.
   *
   * @param  alg  Symmetric cipher algorithm used for encryption/decryption.
   * @param  digest  Digest algorithm used for PBE pseudorandom function.
   * @param  params  Key generation function salt and iteration count.
   * @param  keyBitLength  Size of derived keys in bits.
   */
  public PKCS12EncryptionScheme(
    final SymmetricAlgorithm alg,
    final DigestAlgorithm digest,
    final PBEParameter params,
    final int keyBitLength)
  {
    setCipher(alg);
    setGenerator(
      new PKCS12KeyGenerator(
        digest,
        params.getSalt(),
        params.getIterationCount()));
    setKeyLength(keyBitLength);
  }
}
