/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.pbe;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.pbe.EncryptionScheme;
import edu.vt.middleware.crypt.symmetric.SymmetricAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractEncryptionScheme
implements EncryptionScheme {
    protected SymmetricAlgorithm cipher;

    public byte[] encrypt(char[] password, byte[] plaintext) throws CryptException {
        this.initCipher(password);
        this.cipher.initEncrypt();
        return this.cipher.encrypt(plaintext);
    }

    public void encrypt(char[] password, InputStream in, OutputStream out) throws CryptException, IOException {
        this.initCipher(password);
        this.cipher.initEncrypt();
        this.cipher.encrypt(in, out);
    }

    public byte[] decrypt(char[] password, byte[] ciphertext) throws CryptException {
        this.initCipher(password);
        this.cipher.initDecrypt();
        return this.cipher.decrypt(ciphertext);
    }

    public void decrypt(char[] password, InputStream in, OutputStream out) throws CryptException, IOException {
        this.initCipher(password);
        this.cipher.initDecrypt();
        this.cipher.decrypt(in, out);
    }

    protected void setCipher(SymmetricAlgorithm alg) {
        if (alg == null) {
            throw new IllegalArgumentException("Cipher cannot be null.");
        }
        this.cipher = alg;
    }

    protected abstract void initCipher(char[] var1);
}

