/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.pbe;

import edu.vt.middleware.crypt.pbe.AbstractVariableKeySizeEncryptionScheme;
import edu.vt.middleware.crypt.pbe.OpenSSLKeyGenerator;
import edu.vt.middleware.crypt.symmetric.SymmetricAlgorithm;

public class OpenSSLEncryptionScheme
extends AbstractVariableKeySizeEncryptionScheme {
    public OpenSSLEncryptionScheme(SymmetricAlgorithm alg, byte[] salt, int keyBitLength) {
        this.setCipher(alg);
        this.setGenerator(new OpenSSLKeyGenerator(salt));
        this.setKeyLength(keyBitLength);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OpenSSLEncryptionScheme(String algId, byte[] iv) {
        String alg;
        String mode = "CBC";
        String padding = "PKCS5Padding";
        if (algId.endsWith("-CFB")) {
            mode = "CFB";
            padding = "NoPadding";
        } else if (algId.endsWith("-OFB")) {
            mode = "CFB";
            padding = "NoPadding";
        } else if (algId.endsWith("-ECB")) {
            mode = "ECB";
        }
        if (algId.startsWith("DES-EDE3")) {
            alg = "DESede";
            this.setKeyLength(192);
        } else if (algId.startsWith("DES")) {
            alg = "DES";
            this.setKeyLength(64);
        } else if (algId.startsWith("RC2")) {
            alg = "RC2";
            if (algId.startsWith("RC2-40")) {
                this.setKeyLength(40);
            } else if (algId.startsWith("RC2-64")) {
                this.setKeyLength(64);
            } else {
                this.setKeyLength(128);
            }
        } else {
            if (!algId.startsWith("AES")) throw new IllegalArgumentException("Unknown algorithm " + algId);
            alg = "AES";
            if (algId.startsWith("AES-128")) {
                this.setKeyLength(128);
            } else if (algId.startsWith("AES-192")) {
                this.setKeyLength(192);
            } else {
                if (!algId.startsWith("AES-256")) throw new IllegalArgumentException("Unknown AES cipher " + algId);
                this.setKeyLength(256);
            }
        }
        byte[] salt = iv;
        if (iv.length > 8) {
            salt = new byte[8];
            System.arraycopy(iv, 0, salt, 0, 8);
        }
        this.setCipher(SymmetricAlgorithm.newInstance(alg, mode, padding));
        this.setGenerator(new OpenSSLKeyGenerator(salt));
        this.cipher.setIV(iv);
    }
}

