/*
  $Id: Dictionary.java 1700 2010-10-27 20:08:24Z dfisher $

  Copyright (C) 2003-2010 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1700 $
  Updated: $Date: 2010-10-27 16:08:24 -0400 (Wed, 27 Oct 2010) $
*/
package edu.vt.middleware.dictionary;

/**
 * Base interface for all dictionaries.
 *
 * @author  Middleware Services
 * @version  $Revision: 1700 $ $Date: 2010-10-27 16:08:24 -0400 (Wed, 27 Oct 2010) $
 */
public interface Dictionary
{


  /**
   * Returns whether the supplied word exists in the dictionary.
   *
   * @param  word  <code>String</code> to search for
   *
   * @return  <code>boolean</code> - whether word was found
   */
  boolean search(String word);
}
