/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public abstract class AbstractTLSSocketFactory
extends SSLSocketFactory {
    public static final String DEFAULT_PROTOCOL = "TLS";
    protected SSLSocketFactory factory;
    protected String[] cipherSuites;
    protected String[] protocols;

    public abstract void initialize() throws GeneralSecurityException;

    public SSLSocketFactory getFactory() {
        return this.factory;
    }

    public String[] getEnabledCipherSuites() {
        return this.cipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.protocols;
    }

    public void setEnabledCipherSuites(String[] s) {
        this.cipherSuites = s;
    }

    public void setEnabledProtocols(String[] s) {
        this.protocols = s;
    }

    protected SSLSocket initSSLSocket(SSLSocket s) {
        if (this.cipherSuites != null) {
            s.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.protocols != null) {
            s.setEnabledProtocols(this.protocols);
        }
        return s;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = null;
        if (this.factory != null) {
            socket = this.initSSLSocket((SSLSocket)this.factory.createSocket(s, host, port, autoClose));
        }
        return socket;
    }

    public Socket createSocket() throws IOException {
        SSLSocket socket = null;
        if (this.factory != null) {
            socket = this.initSSLSocket((SSLSocket)this.factory.createSocket());
        }
        return socket;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = null;
        if (this.factory != null) {
            socket = this.initSSLSocket((SSLSocket)this.factory.createSocket(host, port));
        }
        return socket;
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = null;
        if (this.factory != null) {
            socket = this.initSSLSocket((SSLSocket)this.factory.createSocket(address, port, localAddress, localPort));
        }
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket socket = null;
        if (this.factory != null) {
            socket = this.initSSLSocket((SSLSocket)this.factory.createSocket(host, port));
        }
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocket socket = null;
        if (this.factory != null) {
            socket = this.initSSLSocket((SSLSocket)this.factory.createSocket(host, port, localHost, localPort));
        }
        return socket;
    }

    public String[] getDefaultCipherSuites() {
        String[] ciphers = null;
        if (this.factory != null) {
            ciphers = this.factory.getDefaultCipherSuites();
        }
        return ciphers;
    }

    public String[] getSupportedCipherSuites() {
        String[] ciphers = null;
        if (this.factory != null) {
            ciphers = this.factory.getSupportedCipherSuites();
        }
        return ciphers;
    }
}

