/*
  $Id: HistoryRule.java 1841 2011-02-25 19:05:47Z dfisher $

  Copyright (C) 2003-2011 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1841 $
  Updated: $Date: 2011-02-25 14:05:47 -0500 (Fri, 25 Feb 2011) $
*/
package edu.vt.middleware.password;

/**
 * <code>HistoryRule</code> contains methods for determining if a password
 * matches one of any previous password a user has chosen. If no password
 * history has been set or an empty history has been set, then passwords will
 * meet this rule.
 *
 * @author  Middleware Services
 * @version  $Revision: 1841 $ $Date: 2011-02-25 14:05:47 -0500 (Fri, 25 Feb 2011) $
 */
public class HistoryRule extends AbstractDigester implements Rule
{


  /** {@inheritDoc} */
  public RuleResult validate(final PasswordData passwordData)
  {
    final RuleResult result = new RuleResult(true);

    if (!passwordData.getPasswordHistory().isEmpty()) {
      for (String p : passwordData.getPasswordHistory()) {
        if (this.digest != null) {
          final String hash = this.digest.digest(
            passwordData.getPassword().getText().getBytes(),
            this.converter);
          if (p.equals(hash)) {
            result.setValid(false);
            result.getDetails().add(
              new RuleResultDetail(
                String.format(
                  "Password matches one of %s previous passwords",
                  passwordData.getPasswordHistory().size())));
          }
        } else {
          if (p.equals(passwordData.getPassword().getText())) {
            result.setValid(false);
            result.getDetails().add(
              new RuleResultDetail(
                String.format(
                  "Password matches one of %s previous passwords",
                  passwordData.getPasswordHistory().size())));
          }
        }
      }
    }
    return result;
  }
}
