/*
  $Id: PasswordValidator.java 1841 2011-02-25 19:05:47Z dfisher $

  Copyright (C) 2003-2011 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1841 $
  Updated: $Date: 2011-02-25 14:05:47 -0500 (Fri, 25 Feb 2011) $
*/
package edu.vt.middleware.password;

/**
 * <code>PasswordValidator</code> provides methods to running rule validation
 * against password data.
 *
 * @author  Middleware Services
 * @version  $Revision: 1841 $ $Date: 2011-02-25 14:05:47 -0500 (Fri, 25 Feb 2011) $
 */

public final class PasswordValidator
{


  /** Default constructor. */
  private PasswordValidator() {}


  /**
   * Validates the supplied password data against the supplied rule.
   *
   * @param  rule  <code>Rule</code> to validate password with
   * @param  passwordData  <code>PasswordData</code> to validate
   *
   * @return  <code>RuleResult</code>
   */
  public static RuleResult validate(
    final Rule rule,
    final PasswordData passwordData)
  {
    return rule.validate(passwordData);
  }
}
