/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.CharacterRule;
import edu.vt.middleware.password.Password;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;

public abstract class AbstractCharacterRule
implements CharacterRule {
    protected int numCharacters = 1;

    @Override
    public void setNumberOfCharacters(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("argument must be greater than zero");
        }
        this.numCharacters = n;
    }

    @Override
    public int getNumberOfCharacters() {
        return this.numCharacters;
    }

    protected abstract int getNumberOfCharacterType(Password var1);

    protected abstract String getRuleResultDetailMessage();

    @Override
    public RuleResult validate(PasswordData passwordData) {
        if (this.getNumberOfCharacterType(passwordData.getPassword()) >= this.numCharacters) {
            return new RuleResult(true);
        }
        return new RuleResult(false, new RuleResultDetail(this.getRuleResultDetailMessage()));
    }

    public String toString() {
        return String.format("%s@%h::numberOfCharacters=%s", this.getClass().getName(), this.hashCode(), this.numCharacters);
    }
}

