/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.CharacterRule;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.ArrayList;
import java.util.List;

public class CharacterCharacteristicsRule
implements Rule {
    private List<CharacterRule> rules = new ArrayList<CharacterRule>();
    private int numCharacteristics = 1;

    public List<CharacterRule> getRules() {
        return this.rules;
    }

    public void setRules(List<CharacterRule> l) {
        this.rules = l;
    }

    public void setNumberOfCharacteristics(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("argument must be greater than zero");
        }
        this.numCharacteristics = n;
    }

    public int getNumberOfCharacteristics() {
        return this.numCharacteristics;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        int successCount = 0;
        RuleResult result = new RuleResult(true);
        for (CharacterRule rule : this.rules) {
            RuleResult rr = rule.validate(passwordData);
            if (!rr.isValid()) {
                result.getDetails().addAll(rr.getDetails());
                continue;
            }
            ++successCount;
        }
        if (successCount < this.numCharacteristics) {
            result.setValid(false);
            result.getDetails().add(0, new RuleResultDetail(String.format("Password did not meet %s required character characteristics", this.numCharacteristics)));
        }
        return result;
    }

    public String toString() {
        return String.format("%s@%h::numberOfCharacteristics=%s,rules=%s", this.getClass().getName(), this.hashCode(), this.numCharacteristics, this.rules);
    }
}

