/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.AbstractCharacterRule;
import edu.vt.middleware.password.Password;

public class NonAlphanumericCharacterRule
extends AbstractCharacterRule {
    public NonAlphanumericCharacterRule() {
    }

    public NonAlphanumericCharacterRule(int num) {
        this.setNumberOfCharacters(num);
    }

    @Override
    public String getValidCharacters() {
        return "`~!@#$%^&*()-_=+[{]}\\|;:'\"<,>./?";
    }

    @Override
    protected int getNumberOfCharacterType(Password password) {
        return password.getNumberOfNonAlphanumeric();
    }

    @Override
    protected String getRuleResultDetailMessage() {
        return String.format("Password must contain at least %s non-alphanumeric characters", this.numCharacters);
    }
}

