/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.dictionary.Dictionary;
import edu.vt.middleware.dictionary.FileWordList;
import edu.vt.middleware.dictionary.TernaryTreeDictionary;
import edu.vt.middleware.dictionary.WordList;
import edu.vt.middleware.password.AlphabeticalCharacterRule;
import edu.vt.middleware.password.AlphabeticalSequenceRule;
import edu.vt.middleware.password.CharacterCharacteristicsRule;
import edu.vt.middleware.password.DictionarySubstringRule;
import edu.vt.middleware.password.DigitCharacterRule;
import edu.vt.middleware.password.LengthRule;
import edu.vt.middleware.password.LowercaseCharacterRule;
import edu.vt.middleware.password.NonAlphanumericCharacterRule;
import edu.vt.middleware.password.NumericalSequenceRule;
import edu.vt.middleware.password.Password;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.PasswordValidator;
import edu.vt.middleware.password.QwertySequenceRule;
import edu.vt.middleware.password.RepeatCharacterRegexRule;
import edu.vt.middleware.password.RuleList;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import edu.vt.middleware.password.UppercaseCharacterRule;
import edu.vt.middleware.password.UsernameRule;
import java.io.RandomAccessFile;

public final class PasswordCli {
    private PasswordCli() {
    }

    public static void main(String[] args) throws Exception {
        RuleList ruleList = new RuleList();
        String username = null;
        String password = null;
        try {
            if (args.length < 2) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 0; i < args.length; ++i) {
                if ("-l".equals(args[i])) {
                    int min = Integer.parseInt(args[++i]);
                    int max = Integer.parseInt(args[++i]);
                    LengthRule rule = new LengthRule(min, max);
                    ruleList.getRules().add(rule);
                    continue;
                }
                if ("-c".equals(args[i])) {
                    CharacterCharacteristicsRule rule = new CharacterCharacteristicsRule();
                    rule.getRules().add(new DigitCharacterRule(Integer.parseInt(args[++i])));
                    rule.getRules().add(new AlphabeticalCharacterRule(Integer.parseInt(args[++i])));
                    rule.getRules().add(new NonAlphanumericCharacterRule(Integer.parseInt(args[++i])));
                    rule.getRules().add(new UppercaseCharacterRule(Integer.parseInt(args[++i])));
                    rule.getRules().add(new LowercaseCharacterRule(Integer.parseInt(args[++i])));
                    rule.setNumberOfCharacteristics(Integer.parseInt(args[++i]));
                    ruleList.getRules().add(rule);
                    continue;
                }
                if ("-d".equals(args[i])) {
                    TernaryTreeDictionary dict = new TernaryTreeDictionary((WordList)new FileWordList(new RandomAccessFile(args[++i], "r"), false));
                    DictionarySubstringRule rule = new DictionarySubstringRule((Dictionary)dict);
                    rule.setMatchBackwards(true);
                    rule.setWordLength(Integer.parseInt(args[++i]));
                    ruleList.getRules().add(rule);
                    continue;
                }
                if ("-u".equals(args[i])) {
                    ruleList.getRules().add(new UsernameRule(true, true));
                    username = args[++i];
                    continue;
                }
                if ("-s".equals(args[i])) {
                    ruleList.getRules().add(new QwertySequenceRule());
                    ruleList.getRules().add(new AlphabeticalSequenceRule());
                    ruleList.getRules().add(new NumericalSequenceRule());
                    ruleList.getRules().add(new RepeatCharacterRegexRule());
                    continue;
                }
                if ("-h".equals(args[i])) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                password = args[i];
            }
            if (password == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            RuleResult result = null;
            PasswordData pd = new PasswordData(new Password(password));
            if (username == null) {
                result = PasswordValidator.validate(ruleList, pd);
            } else {
                pd.setUsername(username);
                result = PasswordValidator.validate(ruleList, pd);
            }
            if (result.isValid()) {
                System.out.println("Valid password");
            } else {
                for (RuleResultDetail rrd : result.getDetails()) {
                    System.out.println(rrd.getMessage());
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: java " + PasswordCli.class.getName() + " <options> <password> \\");
            System.out.println("");
            System.out.println("where <options> includes:");
            System.out.println("       -l (Set the min & max password length) \\");
            System.out.println("          <min> \\");
            System.out.println("          <max> \\");
            System.out.println("       -c (Set the characters which must be present in the password) \\");
            System.out.println("          (Each of the following must be >= 0) \\");
            System.out.println("          <digits> \\");
            System.out.println("          <alphabetical> \\");
            System.out.println("          <non-alphanumeric> \\");
            System.out.println("          <uppercase> \\");
            System.out.println("          <lowercase> \\");
            System.out.println("          <num> (Number of these rules to enforce) \\");
            System.out.println("       -d (Test password against a dictionary) \\");
            System.out.println("          <file> (dictionary files) \\");
            System.out.println("          <num> (number of characters in matching words) \\");
            System.out.println("       -u (Test for a user id) \\");
            System.out.println("          <userid> \\");
            System.out.println("       -s (Test for sequences) \\");
            System.out.println("       -h (Print this message) \\");
            System.exit(1);
        }
    }
}

