/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexRule
implements Rule {
    protected final Pattern pattern;

    public RegexRule(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        Matcher m = this.pattern.matcher(passwordData.getPassword().getText());
        if (m.find()) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(this.getRuleResultDetail(m)));
        }
        return result;
    }

    protected String getRuleResultDetail(Matcher m) {
        return String.format("Password contains the regular expression match '%s'", m.group());
    }

    public String toString() {
        return String.format("%s@%h::pattern=%s", this.getClass().getName(), this.hashCode(), this.pattern);
    }
}

