/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.RegexRule;
import java.util.regex.Matcher;

public class RepeatCharacterRegexRule
extends RegexRule {
    public static final int DEFAULT_SEQUENCE_LENGTH = 5;
    public static final int MINIMUM_SEQUENCE_LENGTH = 3;
    private static final String REPEAT_CHAR_REGEX = "([^\\x00-\\x1F])\\1{%d}";

    public RepeatCharacterRegexRule() {
        this(5);
    }

    public RepeatCharacterRegexRule(int sl) {
        super(String.format(REPEAT_CHAR_REGEX, sl - 1));
        if (sl < 3) {
            throw new IllegalArgumentException(String.format("sequence length must be >= %s", 3));
        }
    }

    @Override
    protected String getRuleResultDetail(Matcher m) {
        return String.format("Password contains the repeated character '%s'", m.group());
    }
}

