/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.AbstractDigester;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.Map;

public class SourceRule
extends AbstractDigester
implements Rule {
    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        if (!passwordData.getPasswordSources().isEmpty()) {
            for (Map.Entry<String, String> entry : passwordData.getPasswordSources().entrySet()) {
                String p = entry.getValue();
                if (this.digest != null) {
                    String hash = this.digest.digest(passwordData.getPassword().getText().getBytes(), this.converter);
                    if (!p.equals(hash)) continue;
                    result.setValid(false);
                    result.getDetails().add(new RuleResultDetail(String.format("Password can not be the same as your %s password", entry.getKey())));
                    continue;
                }
                if (!p.equals(passwordData.getPassword().getText())) continue;
                result.setValid(false);
                result.getDetails().add(new RuleResultDetail(String.format("Password can not be the same as your %s password", entry.getKey())));
            }
        }
        return result;
    }
}

