/*
  $Id: CharacterRule.java 1724 2010-10-29 17:47:59Z dfisher $

  Copyright (C) 2003-2010 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1724 $
  Updated: $Date: 2010-10-29 13:47:59 -0400 (Fri, 29 Oct 2010) $
*/
package edu.vt.middleware.password;

/**
 * <code>CharacterRule</code> is a marker interface of rules implementing
 * character enforcement.
 *
 * @author  Middleware Services
 * @version  $Revision: 1724 $ $Date: 2010-10-29 13:47:59 -0400 (Fri, 29 Oct 2010) $
 */
public interface CharacterRule extends Rule
{


  /**
   * This sets the number of characters to require in a password.
   *
   * @param  n  <code>int</code> number of characters to require where n > 0
   */
  void setNumberOfCharacters(int n);


  /**
   * This returns the number of characters which must exist in order for a
   * password to meet the requirements of this rule.
   *
   * @return  <code>int</code> number of characters to require
   */
  int getNumberOfCharacters();


  /**
   * Returns the characters that are considered valid for this rule.
   *
   * @return  <code>char[]</code>
   */
  String getValidCharacters();
}
