/*
  $Id: DictionaryRule.java 1724 2010-10-29 17:47:59Z dfisher $

  Copyright (C) 2003-2010 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1724 $
  Updated: $Date: 2010-10-29 13:47:59 -0400 (Fri, 29 Oct 2010) $
*/
package edu.vt.middleware.password;

import edu.vt.middleware.dictionary.Dictionary;

/**
 * <code>DictionaryRule</code> determines if a password matches a dictionary
 * word. The checker will optionally also check for reversed words.
 *
 * @author  Middleware Services
 * @version  $Revision: 1724 $ $Date: 2010-10-29 13:47:59 -0400 (Fri, 29 Oct 2010) $
 */
public class DictionaryRule extends AbstractDictionaryRule
{

  /**
   * This creates a new a new <code>DictionaryRule</code> without supplying a
   * dictionary. The dictionary should be set using the {@link
   * #setDictionary(Dictionary)} method.
   */
  public DictionaryRule() {}


  /**
   * This creates a new <code>DictionaryRule</code> with the supplied
   * dictionary. The dictionary should be ready to use when passed to this
   * constructor.
   *
   * @param  dict  <code>Dictionary</code> to use for searching
   */
  public DictionaryRule(final Dictionary dict)
  {
    this.dictionary = dict;
  }


  /** {@inheritDoc} */
  protected String doWordSearch(final String text)
  {
    if (this.dictionary.search(text)) {
      return text;
    }
    return null;
  }
}
