/*
  $Id: HistoryRule.java 1724 2010-10-29 17:47:59Z dfisher $

  Copyright (C) 2003-2010 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1724 $
  Updated: $Date: 2010-10-29 13:47:59 -0400 (Fri, 29 Oct 2010) $
*/
package edu.vt.middleware.password;

/**
 * <code>HistoryRule</code> contains methods for determining if a password
 * matches one of any previous password a user has chosen. If no password
 * history has been set or an empty history has been set, then passwords will
 * meet this rule.
 *
 * @author  Middleware Services
 * @version  $Revision: 1724 $ $Date: 2010-10-29 13:47:59 -0400 (Fri, 29 Oct 2010) $
 */
public class HistoryRule extends AbstractDigester implements Rule
{


  /** {@inheritDoc} */
  public RuleResult validate(final PasswordData passwordData)
  {
    final RuleResult result = new RuleResult(true);

    if (!passwordData.getPasswordHistory().isEmpty()) {
      for (String p : passwordData.getPasswordHistory()) {
        if (this.digest != null) {
          final String hash = this.digest.digest(
            passwordData.getPassword().getText().getBytes(),
            this.converter);
          if (p.equals(hash)) {
            result.setValid(false);
            result.getDetails().add(
              new RuleResultDetail(
                String.format(
                  "Password matches one of %s previous passwords",
                  passwordData.getPasswordHistory().size())));
          }
        } else {
          if (p.equals(passwordData.getPassword().getText())) {
            result.setValid(false);
            result.getDetails().add(
              new RuleResultDetail(
                String.format(
                  "Password matches one of %s previous passwords",
                  passwordData.getPasswordHistory().size())));
          }
        }
      }
    }
    return result;
  }
}
