/*
  $Id: WhitespaceRule.java 1724 2010-10-29 17:47:59Z dfisher $

  Copyright (C) 2003-2010 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1724 $
  Updated: $Date: 2010-10-29 13:47:59 -0400 (Fri, 29 Oct 2010) $
*/
package edu.vt.middleware.password;

/**
 * <code>WhitespaceRule</code> contains methods for determining if a password
 * contains whitespace characters.
 *
 * @author  Middleware Services
 * @version  $Revision: 1724 $ $Date: 2010-10-29 13:47:59 -0400 (Fri, 29 Oct 2010) $
 */
public class WhitespaceRule implements Rule
{


  /** {@inheritDoc} */
  public RuleResult validate(final PasswordData passwordData)
  {
    if (!passwordData.getPassword().containsWhitespace()) {
      return new RuleResult(true);
    } else {
      return
        new RuleResult(
          false,
          new RuleResultDetail(
            "Password cannot contain whitespace characters"));
    }
  }
}
