/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.dictionary.Dictionary;
import edu.vt.middleware.password.DictionaryRuleResult;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResultDetail;

public abstract class AbstractDictionaryRule
implements Rule {
    protected Dictionary dictionary;
    protected boolean matchBackwards;

    public void setDictionary(Dictionary dict) {
        this.dictionary = dict;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public void setMatchBackwards(boolean b) {
        this.matchBackwards = b;
    }

    public boolean isMatchBackwards() {
        return this.matchBackwards;
    }

    @Override
    public DictionaryRuleResult validate(PasswordData passwordData) {
        DictionaryRuleResult result = new DictionaryRuleResult(true);
        String text = passwordData.getPassword().getText();
        String matchingWord = this.doWordSearch(text);
        if (matchingWord != null) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(String.format("Password contains the dictionary word '%s'", matchingWord)));
            result.setMatchingWord(matchingWord);
        }
        if (this.matchBackwards && (matchingWord = this.doWordSearch(text = new StringBuilder(passwordData.getPassword().getText()).reverse().toString())) != null) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(String.format("Password contains the reversed dictionary word '%s'", matchingWord)));
            result.setMatchingWord(matchingWord);
        }
        return result;
    }

    protected abstract String doWordSearch(String var1);

    public String toString() {
        return String.format("%s@%h::dictionary=%s,matchBackwards=%s", this.getClass().getName(), this.hashCode(), this.dictionary, this.matchBackwards);
    }
}

