/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;

public class LengthRule
implements Rule {
    private int minimumLength;
    private int maximumLength = Integer.MAX_VALUE;

    public LengthRule() {
    }

    public LengthRule(int length) {
        this.minimumLength = length;
        this.maximumLength = length;
    }

    public LengthRule(int minLength, int maxLength) {
        this.minimumLength = minLength;
        this.maximumLength = maxLength;
    }

    public void setMinimumLength(int minLength) {
        this.minimumLength = minLength;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMaximumLength(int maxLength) {
        this.maximumLength = maxLength;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        if (passwordData.getPassword().length() >= this.minimumLength && passwordData.getPassword().length() <= this.maximumLength) {
            result.setValid(true);
        } else if (this.minimumLength == this.maximumLength) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(String.format("Password length must be %s characters", this.minimumLength)));
        } else if (this.maximumLength == Integer.MAX_VALUE) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(String.format("Password length must be greater than or equal to %s characters", this.minimumLength)));
        } else {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(String.format("Password length must be greater than or equal to %s and less than or equal to %s characters", this.minimumLength, this.maximumLength)));
        }
        return result;
    }

    public String toString() {
        return String.format("%s@%h::minimumLength=%s,maximumLength=%s", this.getClass().getName(), this.hashCode(), this.minimumLength, this.maximumLength);
    }
}

