/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

public class Password {
    private String password;
    private StringBuilder digits;
    private StringBuilder nonDigits;
    private StringBuilder alphabetical;
    private StringBuilder nonAlphabetical;
    private StringBuilder alphanumeric;
    private StringBuilder nonAlphanumeric;
    private StringBuilder uppercase;
    private StringBuilder lowercase;
    private StringBuilder whitespace;

    public Password(String text) {
        this.password = text;
        this.digits = new StringBuilder(this.password.length());
        this.nonDigits = new StringBuilder(this.password.length());
        this.alphabetical = new StringBuilder(this.password.length());
        this.nonAlphabetical = new StringBuilder(this.password.length());
        this.alphanumeric = new StringBuilder(this.password.length());
        this.nonAlphanumeric = new StringBuilder(this.password.length());
        this.uppercase = new StringBuilder(this.password.length());
        this.lowercase = new StringBuilder(this.password.length());
        this.whitespace = new StringBuilder(this.password.length());
        for (int i = 0; i < this.password.length(); ++i) {
            char c = this.password.charAt(i);
            if (Character.isDigit(c)) {
                this.digits.append(c);
                this.alphanumeric.append(c);
                this.nonAlphabetical.append(c);
                continue;
            }
            if (Character.isLetter(c)) {
                this.nonDigits.append(c);
                this.alphanumeric.append(c);
                this.alphabetical.append(c);
                if (Character.isUpperCase(c)) {
                    this.uppercase.append(c);
                    continue;
                }
                if (!Character.isLowerCase(c)) continue;
                this.lowercase.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                this.whitespace.append(c);
            }
            this.nonDigits.append(c);
            this.nonAlphanumeric.append(c);
            this.nonAlphabetical.append(c);
        }
    }

    public String getText() {
        return this.password;
    }

    public int length() {
        return this.password.length();
    }

    public boolean containsDigits() {
        return this.digits.length() > 0;
    }

    public int getNumberOfDigits() {
        return this.digits.length();
    }

    public char[] getDigits() {
        char[] array = null;
        if (this.digits != null && this.digits.length() > 0) {
            array = this.digits.toString().toCharArray();
        }
        return array;
    }

    public boolean containsNonDigits() {
        return this.nonDigits.length() > 0;
    }

    public int getNumberOfNonDigits() {
        return this.nonDigits.length();
    }

    public char[] getNonDigits() {
        char[] array = null;
        if (this.nonDigits != null && this.nonDigits.length() > 0) {
            array = this.nonDigits.toString().toCharArray();
        }
        return array;
    }

    public boolean containsAlphabetical() {
        return this.alphabetical.length() > 0;
    }

    public int getNumberOfAlphabetical() {
        return this.alphabetical.length();
    }

    public char[] getAlphabetical() {
        char[] array = null;
        if (this.alphabetical != null && this.alphabetical.length() > 0) {
            array = this.alphabetical.toString().toCharArray();
        }
        return array;
    }

    public boolean containsNonAlphabetical() {
        return this.nonAlphabetical.length() > 0;
    }

    public int getNumberOfNonAlphabetical() {
        return this.nonAlphabetical.length();
    }

    public char[] getNonAlphabetical() {
        char[] array = null;
        if (this.nonAlphabetical != null && this.nonAlphabetical.length() > 0) {
            array = this.nonAlphabetical.toString().toCharArray();
        }
        return array;
    }

    public boolean containsAlphanumeric() {
        return this.alphanumeric.length() > 0;
    }

    public int getNumberOfAlphanumeric() {
        return this.alphanumeric.length();
    }

    public char[] getAlphanumeric() {
        char[] array = null;
        if (this.alphanumeric != null && this.alphanumeric.length() > 0) {
            array = this.alphanumeric.toString().toCharArray();
        }
        return array;
    }

    public boolean containsNonAlphanumeric() {
        return this.nonAlphanumeric.length() > 0;
    }

    public int getNumberOfNonAlphanumeric() {
        return this.nonAlphanumeric.length();
    }

    public char[] getNonAlphanumeric() {
        char[] array = null;
        if (this.nonAlphanumeric != null && this.nonAlphanumeric.length() > 0) {
            array = this.nonAlphanumeric.toString().toCharArray();
        }
        return array;
    }

    public boolean containsUppercase() {
        return this.uppercase.length() > 0;
    }

    public int getNumberOfUppercase() {
        return this.uppercase.length();
    }

    public char[] getUppercase() {
        char[] array = null;
        if (this.uppercase != null && this.uppercase.length() > 0) {
            array = this.uppercase.toString().toCharArray();
        }
        return array;
    }

    public boolean containsLowercase() {
        return this.lowercase.length() > 0;
    }

    public int getNumberOfLowercase() {
        return this.lowercase.length();
    }

    public char[] getLowercase() {
        char[] array = null;
        if (this.lowercase != null && this.lowercase.length() > 0) {
            array = this.lowercase.toString().toCharArray();
        }
        return array;
    }

    public boolean containsWhitespace() {
        return this.whitespace.length() > 0;
    }

    public int getNumberOfWhitespace() {
        return this.whitespace.length();
    }

    public char[] getWhitespace() {
        char[] array = null;
        if (this.whitespace != null && this.whitespace.length() > 0) {
            array = this.whitespace.toString().toCharArray();
        }
        return array;
    }

    public String toString() {
        return this.password;
    }
}

