/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;

public class SequenceRule
implements Rule {
    private static final String[] SEQUENCES = new String[]{"aaaaa", "bbbbb", "ccccc", "ddddd", "eeeee", "fffff", "ggggg", "hhhhh", "iiiii", "jjjjj", "kkkkk", "lllll", "mmmmm", "nnnnn", "ooooo", "ppppp", "qqqqq", "rrrrr", "sssss", "ttttt", "uuuuu", "vvvvv", "wwwww", "xxxxx", "yyyyy", "zzzzz", "11111", "22222", "33333", "44444", "55555", "66666", "77777", "88888", "99999", "00000", "qwert", "werty", "ertyu", "rtyui", "tyuio", "yuiop", "uiop[", "iop[]", "op[]\\", "asdfg", "sdfgh", "dfghj", "fghjk", "ghjkl", "hjkl;", "jkl;'", "zxcvb", "xcvbn", "cvbnm", "vbnm,", "bnm,.", "nm,./", "`1234", "12345", "23456", "34567", "45678", "56789", "67890", "7890-", "890-="};
    private static final String[] REVERSE_SEQUENCES = new String[SEQUENCES.length];
    private boolean ignoreCase;
    private boolean matchBackwards;

    public SequenceRule() {
    }

    public SequenceRule(boolean mb, boolean ic) {
        this.setMatchBackwards(mb);
        this.setIgnoreCase(ic);
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setMatchBackwards(boolean b) {
        this.matchBackwards = b;
    }

    public boolean isMatchBackwards() {
        return this.matchBackwards;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        String text = passwordData.getPassword().getText();
        if (this.ignoreCase) {
            text = text.toLowerCase();
        }
        for (int i = 0; i < SEQUENCES.length; ++i) {
            if (text.indexOf(SEQUENCES[i]) == -1) continue;
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(String.format("Password contains the keyboard sequence '%s'", SEQUENCES[i])));
        }
        if (this.matchBackwards) {
            for (int j = 0; j < REVERSE_SEQUENCES.length; ++j) {
                if (text.indexOf(REVERSE_SEQUENCES[j]) == -1) continue;
                result.setValid(false);
                result.getDetails().add(new RuleResultDetail(String.format("Password contains the keyboard sequence '%s'", REVERSE_SEQUENCES[j])));
            }
        }
        return result;
    }

    public String toString() {
        return String.format("%s@%h::ignoreCase=%s,matchBackwards=%s", this.getClass().getName(), this.hashCode(), this.ignoreCase, this.matchBackwards);
    }

    static {
        for (int i = 0; i < REVERSE_SEQUENCES.length; ++i) {
            SequenceRule.REVERSE_SEQUENCES[i] = new StringBuilder(SEQUENCES[i]).reverse().toString();
        }
    }
}

