/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;

public class UsernameRule
implements Rule {
    private boolean matchBackwards;
    private boolean ignoreCase;

    public UsernameRule() {
    }

    public UsernameRule(boolean mb, boolean ic) {
        this.setMatchBackwards(mb);
        this.setIgnoreCase(ic);
    }

    public void setMatchBackwards(boolean b) {
        this.matchBackwards = b;
    }

    public boolean isMatchBackwards() {
        return this.matchBackwards;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        String text = passwordData.getPassword().getText();
        String user = passwordData.getUsername();
        String reverseUser = new StringBuilder(user).reverse().toString();
        if (this.ignoreCase) {
            text = text.toLowerCase();
            user = user.toLowerCase();
            reverseUser = reverseUser.toLowerCase();
        }
        if (text.indexOf(user) != -1) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(String.format("Password contains the user id '%s'", user)));
        }
        if (this.matchBackwards && text.indexOf(reverseUser) != -1) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(String.format("Password contains the backwards user id '%s'", reverseUser)));
        }
        return result;
    }

    public String toString() {
        return String.format("%s@%h::ignoreCase=%s,matchBackwards=%s", this.getClass().getName(), this.hashCode(), this.ignoreCase, this.matchBackwards);
    }
}

