/*
  $Id: CharacterRule.java 1927 2011-04-27 17:32:24Z dfisher $

  Copyright (C) 2003-2011 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1927 $
  Updated: $Date: 2011-04-27 13:32:24 -0400 (Wed, 27 Apr 2011) $
*/
package edu.vt.middleware.password;

/**
 * Interface for rules implementing character enforcement.
 *
 * @author  Middleware Services
 * @version  $Revision: 1927 $ $Date: 2011-04-27 13:32:24 -0400 (Wed, 27 Apr 2011) $
 */
public interface CharacterRule extends Rule
{


  /**
   * Sets the number of characters to require in a password.
   *
   * @param  n  number of characters to require where n > 0
   */
  void setNumberOfCharacters(int n);


  /**
   * Returns the number of characters which must exist in order for a password
   * to meet the requirements of this rule.
   *
   * @return  number of characters to require
   */
  int getNumberOfCharacters();


  /**
   * Returns the characters that are considered valid for this rule.
   *
   * @return  valid characters
   */
  String getValidCharacters();
}
