/*
  $Id: Rule.java 1920 2011-04-21 15:17:30Z dfisher $

  Copyright (C) 2003-2011 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1920 $
  Updated: $Date: 2011-04-21 11:17:30 -0400 (Thu, 21 Apr 2011) $
*/
package edu.vt.middleware.password;

/**
 * Interface for password strength rules.
 *
 * @author  Middleware Services
 * @version  $Revision: 1920 $ $Date: 2011-04-21 11:17:30 -0400 (Thu, 21 Apr 2011) $
 */
public interface Rule
{


  /**
   * Validates the supplied password data per the requirements of this rule.
   *
   * @param  passwordData  to verify (not null).
   *
   * @return  details on password verification
   *
   * @throws  NullPointerException  if the rule data is null.
   */
  RuleResult validate(PasswordData passwordData);
}
