/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.RuleResultDetail;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MessageResolver {
    public static final String DEFAULT_MESSAGE_PATH = "/messages.properties";
    private final Properties messageProperties;

    public MessageResolver() {
        this(MessageResolver.getDefaultProperties());
    }

    public MessageResolver(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties cannot be null.");
        }
        this.messageProperties = properties;
    }

    public String resolve(RuleResultDetail detail) {
        String key = detail.getErrorCode();
        String message = this.messageProperties.getProperty(key);
        String format = null;
        format = message != null ? String.format(message, detail.getValues()) : (!detail.getParameters().isEmpty() ? String.format("%s:%s", key, detail.getParameters()) : String.format("%s", key));
        return format;
    }

    private static Properties getDefaultProperties() {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = MessageResolver.class.getResourceAsStream(DEFAULT_MESSAGE_PATH);
            props.load(in);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading default message properties.", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }
}

