/*
  $Id: DictionaryRule.java 2704 2013-04-24 21:30:32Z dfisher $

  Copyright (C) 2003-2013 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2704 $
  Updated: $Date: 2013-04-24 17:30:32 -0400 (Wed, 24 Apr 2013) $
*/
package edu.vt.middleware.password;

import edu.vt.middleware.dictionary.Dictionary;

/**
 * Rule for determining if a password matches a dictionary word. This rule will
 * optionally also check for reversed words.
 *
 * @author  Middleware Services
 * @version  $Revision: 2704 $ $Date: 2013-04-24 17:30:32 -0400 (Wed, 24 Apr 2013) $
 */
public class DictionaryRule extends AbstractDictionaryRule
{

  /**
   * Creates a new dictionary rule without supplying a dictionary. The
   * dictionary should be set using {@link #setDictionary(Dictionary)}.
   */
  public DictionaryRule() {}


  /**
   * Creates a new dictionary rule. The dictionary should be ready to use when
   * passed to this constructor.
   *
   * @param  dict  to use for searching
   */
  public DictionaryRule(final Dictionary dict)
  {
    dictionary = dict;
  }


  /** {@inheritDoc} */
  @Override
  protected String doWordSearch(final String text)
  {
    if (dictionary.search(text)) {
      return text;
    }
    return null;
  }
}
