/*
  $Id: DictionaryRule.java 1926 2011-04-26 19:52:24Z dfisher $

  Copyright (C) 2003-2011 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 1926 $
  Updated: $Date: 2011-04-26 15:52:24 -0400 (Tue, 26 Apr 2011) $
*/
package edu.vt.middleware.password;

import edu.vt.middleware.dictionary.Dictionary;

/**
 * Rule for determining if a password matches a dictionary word. This rule will
 * optionally also check for reversed words.
 *
 * @author  Middleware Services
 * @version  $Revision: 1926 $ $Date: 2011-04-26 15:52:24 -0400 (Tue, 26 Apr 2011) $
 */
public class DictionaryRule extends AbstractDictionaryRule
{

  /**
   * Creates a new dictionary rule without supplying a dictionary. The
   * dictionary should be set using {@link #setDictionary(Dictionary)}.
   */
  public DictionaryRule() {}


  /**
   * Creates a new dictionary rule. The dictionary should be ready to use when
   * passed to this constructor.
   *
   * @param  dict  to use for searching
   */
  public DictionaryRule(final Dictionary dict)
  {
    dictionary = dict;
  }


  /** {@inheritDoc} */
  @Override
  protected String doWordSearch(final String text)
  {
    if (dictionary.search(text)) {
      return text;
    }
    return null;
  }
}
