/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.MessageResolver;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.ArrayList;
import java.util.List;

public class PasswordValidator {
    private final List<Rule> passwordRules;
    private final MessageResolver messageResolver;

    public PasswordValidator(List<Rule> rules) {
        this(new MessageResolver(), rules);
    }

    public PasswordValidator(MessageResolver resolver, List<Rule> rules) {
        this.messageResolver = resolver;
        this.passwordRules = rules;
    }

    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        for (Rule rule : this.passwordRules) {
            RuleResult rr = rule.validate(passwordData);
            if (rr.isValid()) continue;
            result.setValid(false);
            result.getDetails().addAll(rr.getDetails());
        }
        return result;
    }

    public List<String> getMessages(RuleResult result) {
        ArrayList<String> messages = new ArrayList<String>();
        for (RuleResultDetail detail : result.getDetails()) {
            messages.add(this.messageResolver.resolve(detail));
        }
        return messages;
    }

    public String toString() {
        return String.format("%s@%h::passwordRules=%s,messageResolver=%s", this.getClass().getName(), this.hashCode(), this.passwordRules, this.messageResolver);
    }
}

