/*
 * Decompiled with CFR 0.152.
 */
package ee.bitweb.ogone;

import ee.bitweb.ogone.Request;
import ee.bitweb.ogone.exceptions.RequiredFieldException;
import ee.bitweb.ogone.exceptions.ShaComposerException;
import ee.bitweb.ogone.shaComposer.ShaComposer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.validator.routines.UrlValidator;

public abstract class AbstractRequest
implements Request {
    protected String ogoneUri;
    protected Map<String, Object> parameters = new TreeMap<String, Object>();
    protected String response;
    protected ShaComposer shaComposer;
    public ArrayList<String> allowedLanguages = new ArrayList<String>(Arrays.asList("en_US", "cs_CZ", "de_DE", "dk_DK", "el_GR", "es_ES", "fr_FR", "it_IT", "ja_JP", "nl_BE", "nl_NL", "no_NO", "pl_PL", "pt_PT", "ru_RU", "se_SE", "sk_SK", "tr_TR"));
    protected ArrayList<String> ogoneFields = new ArrayList<String>(Arrays.asList("pspid", "orderid", "com", "amount", "currency", "language", "cn", "email", "cardno", "cvc", "ed", "ownerzip", "owneraddress", "ownercty", "ownertown", "ownertelno", "accepturl", "declineurl", "exceptionurl", "cancelurl", "backurl", "complus", "paramplus", "pm", "brand", "title", "bgcolor", "txtcolor", "tblbgcolor", "tbltxtcolor", "buttonbgcolor", "buttontxtcolor", "logo", "fonttype", "tp", "paramvar"));

    public void setShaComposer(ShaComposer shaComposer) {
        this.shaComposer = shaComposer;
    }

    @Override
    public String getOgoneUri() {
        return this.ogoneUri;
    }

    @Override
    public String getShaSign() throws ShaComposerException {
        return this.shaComposer.compose(this.parameters);
    }

    public void setPspid(String pspid) {
        if (pspid.length() > 30) {
            throw new IllegalArgumentException("PSPID is too long");
        }
        this.parameters.put("pspid", pspid);
    }

    public void setOgoneUri(String ogoneUri) {
        this.validateOgoneUri(ogoneUri);
        this.ogoneUri = ogoneUri;
    }

    public void setCustomerName(String customerName) {
        this.setCn(customerName);
    }

    public void setCn(String customerName) {
        this.setParameter("cn", customerName.replaceAll("[\"']", ""));
    }

    public void setParameter(String parameter, Object value) {
        this.parameters.put(parameter, value);
    }

    protected void validateUri(String uri) {
        if (uri.length() > 200) {
            throw new IllegalArgumentException("Uri is too long");
        }
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes, 4L);
        if (!urlValidator.isValid(uri)) {
            throw new IllegalArgumentException("Uri (" + uri + ") is not valid");
        }
    }

    protected void validateOgoneUri(String ogoneUri) {
        this.validateUri(ogoneUri);
        if (!this.getValidOgoneUris().contains(ogoneUri)) {
            throw new IllegalArgumentException("No valid Ogone url");
        }
    }

    public boolean validate() throws RequiredFieldException {
        for (String field : this.getRequiredFields()) {
            if (this.parameters.containsKey(field)) continue;
            throw new RequiredFieldException("Field " + field + " value cannot be empty");
        }
        return true;
    }

    @Override
    public Map toArray() throws RequiredFieldException {
        this.validate();
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            result.put(entry.getKey().toString().toUpperCase(), entry.getValue());
        }
        return result;
    }
}

