/*
 * Decompiled with CFR 0.152.
 */
package ee.bitweb.ogone.directLink;

import ee.bitweb.ogone.AbstractDirectLinkRequest;
import ee.bitweb.ogone.directLink.Eci;
import ee.bitweb.ogone.shaComposer.ShaComposer;
import java.util.Arrays;
import java.util.List;

public class DirectLinkPaymentRequest
extends AbstractDirectLinkRequest {
    public static final String TEST = "https://secure.ogone.com/ncol/test/orderdirect.asp";
    public static final String PRODUCTION = "https://secure.ogone.com/ncol/prod/orderdirect.asp";

    public DirectLinkPaymentRequest() {
        this.ogoneUri = TEST;
    }

    public DirectLinkPaymentRequest(ShaComposer shaComposer) {
        this();
        this.shaComposer = shaComposer;
    }

    @Override
    public List<String> getRequiredFields() {
        return Arrays.asList("pspid", "currency", "amount", "orderid", "userid", "pswd");
    }

    @Override
    public List<String> getValidOgoneUris() {
        return Arrays.asList(TEST, PRODUCTION);
    }

    @Override
    public void setUserId(String userId) {
        if (userId.length() < 8) {
            throw new IllegalArgumentException("User ID is too short");
        }
        this.setParameter("userid", userId);
    }

    @Override
    public void setPassword(String password) {
        this.setPswd(password);
    }

    public void setEci(Eci eci) {
        this.setParameter("eci", eci.toString());
    }
}

