/*
 * Decompiled with CFR 0.152.
 */
package ee.bitweb.ogone.directLink;

import ee.bitweb.ogone.AbstractDirectLinkRequest;
import ee.bitweb.ogone.exceptions.RequiredFieldException;
import ee.bitweb.ogone.shaComposer.ShaComposer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DirectLinkQueryRequest
extends AbstractDirectLinkRequest {
    public static final String TEST = "https://secure.ogone.com/ncol/test/querydirect.asp";
    public static final String PRODUCTION = "https://secure.ogone.com/ncol/prod/querydirect.asp";

    public DirectLinkQueryRequest() {
        this.ogoneUri = TEST;
    }

    public DirectLinkQueryRequest(ShaComposer shaComposer) {
        this.shaComposer = shaComposer;
        this.ogoneUri = TEST;
    }

    public void setPayIdSub(String payIdSub) {
        this.setParameter("payidsub", payIdSub);
    }

    @Override
    public List<String> getRequiredFields() {
        return Arrays.asList("pspid", "userid", "pswd");
    }

    @Override
    public List getValidOgoneUris() {
        return Arrays.asList(TEST, PRODUCTION);
    }

    @Override
    public boolean validate() throws RequiredFieldException {
        super.validate();
        boolean empty = true;
        for (List<String> group : this.getRequiredFieldGroups()) {
            for (String el : group) {
                if (!this.parameters.containsKey(el) || this.parameters.get(el) == null || ((String)this.parameters.get(el)).isEmpty()) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            throw new RequiredFieldException("At least one of these fields should not be empty: " + StringUtils.join(group, (String)", "));
        }
        return true;
    }
}

