/*
 * Decompiled with CFR 0.152.
 */
package ee.bitweb.ogone.shaComposer;

import ee.bitweb.ogone.HashAlgorithm;
import ee.bitweb.ogone.Passphrase;
import ee.bitweb.ogone.exceptions.ShaComposerException;
import ee.bitweb.ogone.parameterFilter.GeneralParameterFilter;
import ee.bitweb.ogone.parameterFilter.ParameterFilter;
import ee.bitweb.ogone.shaComposer.ShaComposer;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AllParametersShaComposer
implements ShaComposer {
    private List<ParameterFilter> parameterFilters = new ArrayList<ParameterFilter>();
    private Passphrase passphrase;
    private HashAlgorithm hashAlgorithm;

    public AllParametersShaComposer() {
    }

    public AllParametersShaComposer(Passphrase passphrase) {
        this.parameterFilters.add(new GeneralParameterFilter());
        this.passphrase = passphrase;
        this.hashAlgorithm = new HashAlgorithm("SHA-1");
    }

    public AllParametersShaComposer(Passphrase passphrase, HashAlgorithm hashAlgorithm) {
        this(passphrase);
        this.hashAlgorithm = hashAlgorithm;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String compose(Map<String, Object> parameters) throws ShaComposerException {
        void var3_7;
        for (ParameterFilter parameterFilter : this.parameterFilters) {
            parameters = parameterFilter.filter(parameters);
        }
        String shaString = "";
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (entry.getValue() == null || entry.getValue() == "") continue;
            shaString = shaString + entry.getKey() + "=" + entry.getValue().toString() + this.passphrase.toString();
        }
        String string = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.hashAlgorithm.toString());
            messageDigest.update(shaString.getBytes("UTF-8"));
            String string2 = new BigInteger(1, messageDigest.digest()).toString(16);
            while (var3_7.length() < 40) {
                String string3 = "0" + (String)var3_7;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ShaComposerException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ShaComposerException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        return var3_7.toUpperCase();
    }

    public void addParameterFilter(ParameterFilter parameterFilter) {
        this.parameterFilters.add(parameterFilter);
    }
}

