/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.azure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.Client;
import ee.carlrobert.llm.client.azure.AzureApiResponseError;
import ee.carlrobert.llm.client.azure.AzureCompletionRequestParams;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.client.openai.completion.OpenAICompletionRequest;
import ee.carlrobert.llm.client.openai.completion.chat.OpenAIChatCompletionEventSourceListener;
import ee.carlrobert.llm.client.openai.completion.chat.response.OpenAIChatCompletionResponse;
import ee.carlrobert.llm.completion.CompletionEventListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class AzureClient
extends Client {
    private static final String BASE_URL = PropertiesLoader.getValue("azure.openai.baseUrl");
    private final AzureCompletionRequestParams requestParams;
    private final boolean activeDirectoryAuthentication;
    private final String url;

    private AzureClient(Builder builder) {
        super(builder);
        this.requestParams = builder.requestParams;
        this.activeDirectoryAuthentication = builder.activeDirectoryAuthentication;
        this.url = String.format(this.getHost() == null ? BASE_URL : this.getHost(), builder.requestParams.getResourceName());
    }

    public EventSource getChatCompletion(OpenAICompletionRequest request, CompletionEventListener completionEventListener) {
        return EventSources.createFactory((OkHttpClient)this.getHttpClient()).newEventSource(this.buildHttpRequest(request), (EventSourceListener)this.getEventSourceListener(completionEventListener));
    }

    public OpenAIChatCompletionResponse getChatCompletion(OpenAICompletionRequest request) {
        OpenAIChatCompletionResponse openAIChatCompletionResponse;
        block8: {
            Response response = this.getHttpClient().newCall(this.buildHttpRequest(request)).execute();
            try {
                openAIChatCompletionResponse = (OpenAIChatCompletionResponse)new ObjectMapper().readValue(Objects.requireNonNull(response.body()).string(), OpenAIChatCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return openAIChatCompletionResponse;
    }

    public Request buildHttpRequest(OpenAICompletionRequest completionRequest) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getRequiredHeaders());
        if (completionRequest.isStream()) {
            headers.put("Accept", "text/event-stream");
        }
        try {
            return new Request.Builder().url(this.url + this.getChatCompletionPath(completionRequest)).headers(Headers.of(headers)).post(RequestBody.create((String)new ObjectMapper().writeValueAsString((Object)completionRequest), (MediaType)MediaType.parse((String)"application/json"))).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Map<String, String> getRequiredHeaders() {
        return this.activeDirectoryAuthentication ? Map.of("Authorization", "Bearer " + this.getApiKey()) : Map.of("api-key", this.getApiKey());
    }

    private String getChatCompletionPath(OpenAICompletionRequest request) {
        String overriddenPath = request.getOverriddenPath();
        if (overriddenPath == null) {
            return String.format("/openai/deployments/%s/chat/completions?api-version=%s", this.requestParams.getDeploymentId(), this.requestParams.getApiVersion());
        }
        return overriddenPath;
    }

    private OpenAIChatCompletionEventSourceListener getEventSourceListener(CompletionEventListener listeners) {
        return new OpenAIChatCompletionEventSourceListener(listeners){

            @Override
            protected ErrorDetails getErrorDetails(String data) throws JsonProcessingException {
                return ((AzureApiResponseError)new ObjectMapper().readValue(data, AzureApiResponseError.class)).getError();
            }
        };
    }

    public static class Builder
    extends Client.Builder {
        private final AzureCompletionRequestParams requestParams;
        private boolean activeDirectoryAuthentication;

        public Builder(String apiKey, AzureCompletionRequestParams requestParams) {
            super(apiKey);
            this.requestParams = requestParams;
        }

        public Builder setActiveDirectoryAuthentication(boolean activeDirectoryAuthentication) {
            this.activeDirectoryAuthentication = activeDirectoryAuthentication;
            return this;
        }

        @Override
        public AzureClient build() {
            return new AzureClient(this);
        }
    }
}

