/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.llama;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.Client;
import ee.carlrobert.llm.client.llama.completion.LlamaCompletionRequest;
import ee.carlrobert.llm.client.llama.completion.LlamaCompletionResponse;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.completion.CompletionEventListener;
import ee.carlrobert.llm.completion.CompletionEventSourceListener;
import java.io.IOException;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class LlamaClient
extends Client {
    private static final String BASE_URL = PropertiesLoader.getValue("llama.baseUrl");
    private final Integer port;

    protected LlamaClient(Builder builder) {
        super(builder);
        this.port = builder.port;
    }

    public EventSource getChatCompletion(LlamaCompletionRequest request, CompletionEventListener completionEventListener) {
        return EventSources.createFactory((OkHttpClient)this.getHttpClient()).newEventSource(this.buildHttpRequest(request), (EventSourceListener)this.getEventSourceListener(completionEventListener));
    }

    public LlamaCompletionResponse getChatCompletion(LlamaCompletionRequest request) {
        LlamaCompletionResponse llamaCompletionResponse;
        block8: {
            Response response = this.getHttpClient().newCall(this.buildHttpRequest(request)).execute();
            try {
                llamaCompletionResponse = (LlamaCompletionResponse)new ObjectMapper().readValue(Objects.requireNonNull(response.body()).string(), LlamaCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get llama completion for the given request:\n" + request, e);
                }
            }
            response.close();
        }
        return llamaCompletionResponse;
    }

    private Request buildHttpRequest(LlamaCompletionRequest request) {
        try {
            String baseHost = this.port == null ? BASE_URL : String.format("http://localhost:%d", this.port);
            return new Request.Builder().url((String)(this.getHost() != null ? this.getHost() : baseHost + "/completion")).header("Cache-Control", "no-cache").header("Content-Type", "application/json").header("Accept", request.isStream() ? "text/event-stream" : "text/json").post(RequestBody.create((String)new ObjectMapper().writeValueAsString((Object)request), (MediaType)MediaType.parse((String)"application/json"))).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private CompletionEventSourceListener getEventSourceListener(CompletionEventListener eventListener) {
        return new CompletionEventSourceListener(eventListener){

            @Override
            protected String getMessage(String data) {
                try {
                    LlamaCompletionResponse response = (LlamaCompletionResponse)new ObjectMapper().readValue(data, LlamaCompletionResponse.class);
                    return response.getContent();
                }
                catch (JacksonException jacksonException) {
                    return "";
                }
            }

            @Override
            protected ErrorDetails getErrorDetails(String error) {
                return new ErrorDetails(error);
            }
        };
    }

    public static class Builder
    extends Client.Builder {
        private Integer port;

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        @Override
        public LlamaClient build() {
            return new LlamaClient(this);
        }
    }
}

