/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.openai;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.Client;
import ee.carlrobert.llm.client.openai.completion.OpenAICompletionRequest;
import ee.carlrobert.llm.client.openai.completion.chat.OpenAIChatCompletionEventSourceListener;
import ee.carlrobert.llm.client.openai.completion.chat.response.OpenAIChatCompletionResponse;
import ee.carlrobert.llm.client.openai.embeddings.EmbeddingData;
import ee.carlrobert.llm.client.openai.embeddings.EmbeddingResponse;
import ee.carlrobert.llm.completion.CompletionEventListener;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class OpenAIClient
extends Client {
    private static final String BASE_URL = PropertiesLoader.getValue("openai.baseUrl");
    private final String organization;

    protected OpenAIClient(Builder builder) {
        super(builder);
        this.organization = builder.organization;
    }

    public EventSource getChatCompletion(OpenAICompletionRequest request, CompletionEventListener completionEventListener) {
        return EventSources.createFactory((OkHttpClient)this.getHttpClient()).newEventSource(this.buildCompletionHttpRequest(request), (EventSourceListener)new OpenAIChatCompletionEventSourceListener(completionEventListener));
    }

    public OpenAIChatCompletionResponse getChatCompletion(OpenAICompletionRequest request) {
        OpenAIChatCompletionResponse openAIChatCompletionResponse;
        block8: {
            Response response = this.getHttpClient().newCall(this.buildCompletionHttpRequest(request)).execute();
            try {
                openAIChatCompletionResponse = (OpenAIChatCompletionResponse)new ObjectMapper().readValue(Objects.requireNonNull(response.body()).string(), OpenAIChatCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return openAIChatCompletionResponse;
    }

    public double[] getEmbedding(String input) {
        return this.getEmbeddings(List.of(input)).get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<double[]> getEmbeddings(List<String> texts) {
        try (Response response = this.getHttpClient().newCall(this.buildRequest((this.getHost() == null ? BASE_URL : this.getHost()) + "/v1/embeddings", texts)).execute();){
            if (response.body() == null) return null;
            List<double[]> list = ((EmbeddingResponse)new ObjectMapper().readValue(response.body().string(), EmbeddingResponse.class)).getData().stream().map(EmbeddingData::getEmbedding).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to fetch embedding", e);
        }
    }

    private Request buildRequest(String url, List<String> texts) throws JsonProcessingException {
        return new Request.Builder().url(url).headers(Headers.of(Map.of("Authorization", "Bearer " + this.getApiKey()))).post(RequestBody.create((String)new ObjectMapper().writeValueAsString(Map.of("input", texts, "model", "text-embedding-ada-002")), (MediaType)MediaType.parse((String)"application/json"))).build();
    }

    protected Request buildCompletionHttpRequest(OpenAICompletionRequest completionRequest) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getRequiredHeaders());
        if (completionRequest.isStream()) {
            headers.put("Accept", "text/event-stream");
        }
        try {
            String host = this.getHost();
            String overriddenPath = completionRequest.getOverriddenPath();
            return new Request.Builder().url((host == null ? BASE_URL : host) + (overriddenPath == null ? "/v1/chat/completions" : overriddenPath)).headers(Headers.of(headers)).post(RequestBody.create((String)new ObjectMapper().writeValueAsString((Object)completionRequest), (MediaType)MediaType.parse((String)"application/json"))).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Map<String, String> getRequiredHeaders() {
        HashMap<String, CallSite> headers = new HashMap<String, CallSite>(Map.of("Authorization", "Bearer " + this.getApiKey()));
        if (this.organization != null && !this.organization.isEmpty()) {
            headers.put("OpenAI-Organization", (CallSite)((Object)this.organization));
        }
        return headers;
    }

    public static class Builder
    extends Client.Builder {
        private String organization;

        public Builder(String apiKey) {
            super(apiKey);
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        @Override
        public OpenAIClient build() {
            return new OpenAIClient(this);
        }
    }
}

