/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.openai.completion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import ee.carlrobert.llm.completion.CompletionRequest;

public abstract class OpenAICompletionRequest
implements CompletionRequest {
    @JsonProperty(value="max_tokens")
    private final int maxTokens;
    private final double temperature;
    @JsonProperty(value="frequency_penalty")
    private final double frequencyPenalty;
    @JsonProperty(value="presence_penalty")
    private final double presencePenalty;
    private final boolean stream;
    @JsonIgnore
    private final String overriddenPath;

    protected OpenAICompletionRequest(Builder builder) {
        this.maxTokens = builder.maxTokens;
        this.temperature = builder.temperature;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.presencePenalty = builder.presencePenalty;
        this.stream = builder.stream;
        this.overriddenPath = builder.overriddenPath;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public boolean isStream() {
        return this.stream;
    }

    public String getOverriddenPath() {
        return this.overriddenPath;
    }

    public static abstract class Builder {
        private int maxTokens = 1000;
        private double temperature = 0.9;
        private double frequencyPenalty = 0.0;
        private double presencePenalty = 0.6;
        private boolean stream = true;
        private String overriddenPath;

        public Builder setMaxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder setTemperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder setFrequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder setPresencePenalty(double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder setStream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder setOverriddenPath(String overriddenPath) {
            this.overriddenPath = overriddenPath;
            return this;
        }

        public abstract OpenAICompletionRequest build();
    }
}

