/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.you;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.Client;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.client.you.UTMParameters;
import ee.carlrobert.llm.client.you.completion.YouCompletionEventListener;
import ee.carlrobert.llm.client.you.completion.YouCompletionRequest;
import ee.carlrobert.llm.client.you.completion.YouCompletionResponse;
import ee.carlrobert.llm.client.you.completion.YouSerpResult;
import ee.carlrobert.llm.completion.CompletionEventListener;
import ee.carlrobert.llm.completion.CompletionEventSourceListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class YouClient
extends Client {
    private static final String BASE_URL = PropertiesLoader.getValue("you.baseUrl");
    private final String sessionId;
    private final String accessToken;
    private final UTMParameters utmParameters;

    private YouClient(Builder builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.accessToken = builder.accessToken;
        this.utmParameters = builder.utmParameters;
    }

    public EventSource getChatCompletion(YouCompletionRequest request, CompletionEventListener completionEventListener) {
        return EventSources.createFactory((OkHttpClient)this.getHttpClient()).newEventSource(this.buildHttpRequest(request), (EventSourceListener)this.getEventSourceListener(completionEventListener));
    }

    private Request buildHttpRequest(YouCompletionRequest request) {
        String guestIdCookie = request.getUserId() != null ? "uuid_guest=" + request.getUserId().toString() + "; " : "";
        return new Request.Builder().url(this.buildHttpUrl(request)).header("Accept", "text/event-stream").header("Cache-Control", "no-cache").header("User-Agent", "youide CodeGPT").header("Cookie", guestIdCookie + "safesearch_guest=Moderate; youpro_subscription=true; you_subscription=free; stytch_session=" + this.sessionId + "; ydc_stytch_session=" + this.sessionId + "; stytch_session_jwt=" + this.accessToken + "; ydc_stytch_session_jwt=" + this.accessToken + "; eg4=" + request.isUseGPT4Model() + "; safesearch_9015f218b47611b62bbbaf61125cd2dac629e65c3d6f47573a2ec0e9b615c691=Moderate; __cf_bm=aN2b3pQMH8XADeMB7bg9s1bJ_bfXBcCHophfOGRg6g0-1693601599-0-AWIt5Mr4Y3xQI4mIJ1lSf4+vijWKDobrty8OopDeBxY+NABe0MRFidF3dCUoWjRt8SVMvBZPI3zkOgcRs7Mz3yazd7f7c58HwW5Xg9jdBjNg;").get().build();
    }

    private HttpUrl buildHttpUrl(YouCompletionRequest request) {
        try {
            URL url = new URL(this.getHost() != null ? this.getHost() : BASE_URL);
            HttpUrl.Builder httpUrlBuilder = new HttpUrl.Builder().scheme(url.getProtocol()).host(url.getHost()).addPathSegments("api/streamingSearch").addQueryParameter("q", request.getPrompt()).addQueryParameter("page", "1").addQueryParameter("cfr", "CodeGPT").addQueryParameter("count", "10").addQueryParameter("safeSearch", "WebPages,Translations,TimeZone,Computation,RelatedSearches").addQueryParameter("domain", "youchat").addQueryParameter("chat", new ObjectMapper().writeValueAsString(request.getMessages()));
            if (url.getPort() != -1) {
                httpUrlBuilder.port(url.getPort());
            }
            if (request.getChatId() != null) {
                httpUrlBuilder.addQueryParameter("chatId", request.getChatId().toString());
            }
            if (request.getQueryTraceId() != null) {
                httpUrlBuilder.addQueryParameter("queryTraceId", request.getQueryTraceId().toString());
            }
            if (this.utmParameters != null) {
                this.addUTMParameters(httpUrlBuilder);
            }
            return httpUrlBuilder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to deserialize request messages", e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid url", e);
        }
    }

    private void addUTMParameters(HttpUrl.Builder httpUrlBuilder) {
        if (this.utmParameters.getId() != null) {
            httpUrlBuilder.addQueryParameter("utm_id", this.utmParameters.getId());
        }
        if (this.utmParameters.getSource() != null) {
            httpUrlBuilder.addQueryParameter("utm_source", this.utmParameters.getSource());
        }
        if (this.utmParameters.getMedium() != null) {
            httpUrlBuilder.addQueryParameter("utm_medium", this.utmParameters.getMedium());
        }
        if (this.utmParameters.getCampaign() != null) {
            httpUrlBuilder.addQueryParameter("utm_campaign", this.utmParameters.getCampaign());
        }
        if (this.utmParameters.getContent() != null) {
            httpUrlBuilder.addQueryParameter("utm_content", this.utmParameters.getContent());
        }
        if (this.utmParameters.getTerm() != null) {
            httpUrlBuilder.addQueryParameter("utm_term", this.utmParameters.getTerm());
        }
    }

    private CompletionEventSourceListener getEventSourceListener(final CompletionEventListener eventListener) {
        return new CompletionEventSourceListener(eventListener){

            @Override
            protected String getMessage(String data) {
                try {
                    List<YouSerpResult> serpResults;
                    YouCompletionResponse response = (YouCompletionResponse)new ObjectMapper().readValue(data, YouCompletionResponse.class);
                    if (eventListener instanceof YouCompletionEventListener && (serpResults = response.getSerpResults()) != null) {
                        ((YouCompletionEventListener)eventListener).onSerpResults(serpResults);
                    }
                    return response.getChatToken();
                }
                catch (JacksonException jacksonException) {
                    return "";
                }
            }

            @Override
            protected ErrorDetails getErrorDetails(String error) {
                return new ErrorDetails(error);
            }
        };
    }

    public static class Builder
    extends Client.Builder {
        private final String sessionId;
        private final String accessToken;
        private UTMParameters utmParameters;

        public Builder(String sessionId, String accessToken) {
            this.sessionId = sessionId;
            this.accessToken = accessToken;
        }

        public Builder setUTMParameters(UTMParameters utmParameters) {
            this.utmParameters = utmParameters;
            return this;
        }

        @Override
        public YouClient build() {
            return new YouClient(this);
        }
    }
}

