/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.you;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.Client;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.client.you.completion.YouCompletionEventListener;
import ee.carlrobert.llm.client.you.completion.YouCompletionRequest;
import ee.carlrobert.llm.client.you.completion.YouCompletionResponse;
import ee.carlrobert.llm.client.you.completion.YouSerpResult;
import ee.carlrobert.llm.completion.CompletionEventListener;
import ee.carlrobert.llm.completion.CompletionEventSourceListener;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class YouClient
extends Client {
    private static final String host = PropertiesLoader.getValue("you.url.host");
    private static final String scheme = PropertiesLoader.getValue("you.url.scheme");
    private static final String port = PropertiesLoader.getValue("you.url.port");
    private final String sessionId;
    private final String accessToken;

    private YouClient(Builder builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.accessToken = builder.accessToken;
    }

    public EventSource getChatCompletion(YouCompletionRequest request, CompletionEventListener completionEventListener) {
        return EventSources.createFactory((OkHttpClient)this.getHttpClient()).newEventSource(this.buildHttpRequest(request), (EventSourceListener)this.getEventSourceListener(completionEventListener));
    }

    private Request buildHttpRequest(YouCompletionRequest request) {
        return new Request.Builder().url(this.buildHttpUrl(request)).header("Accept", "text/event-stream").header("Cache-Control", "no-cache").header("Cookie", "uuid_guest=f9e7e074-54e1-43d9-a12d-30900b066d0c; safesearch_guest=Moderate; youpro_subscription=true; you_subscription=free; stytch_session=" + this.sessionId + "; ydc_stytch_session=" + this.sessionId + "; stytch_session_jwt=" + this.accessToken + "; ydc_stytch_session_jwt=" + this.accessToken + "; safesearch_9015f218b47611b62bbbaf61125cd2dac629e65c3d6f47573a2ec0e9b615c691=Moderate; __cf_bm=aN2b3pQMH8XADeMB7bg9s1bJ_bfXBcCHophfOGRg6g0-1693601599-0-AWIt5Mr4Y3xQI4mIJ1lSf4+vijWKDobrty8OopDeBxY+NABe0MRFidF3dCUoWjRt8SVMvBZPI3zkOgcRs7Mz3yazd7f7c58HwW5Xg9jdBjNg;").get().build();
    }

    private HttpUrl buildHttpUrl(YouCompletionRequest request) {
        try {
            HttpUrl.Builder httpUrlBuilder = new HttpUrl.Builder().scheme(scheme == null ? "https" : scheme).host(host).addPathSegments("api/streamingSearch").addQueryParameter("q", request.getPrompt()).addQueryParameter("page", "1").addQueryParameter("count", "10").addQueryParameter("safeSearch", "WebPages,Translations,TimeZone,Computation,RelatedSearches").addQueryParameter("domain", "youchat").addQueryParameter("chat", new ObjectMapper().writeValueAsString(request.getMessages()));
            if (request.getChatId() != null) {
                httpUrlBuilder.addQueryParameter("chatId", request.getChatId().toString());
            }
            if (request.getQueryTraceId() != null) {
                httpUrlBuilder.addQueryParameter("queryTraceId", request.getQueryTraceId().toString());
            }
            if (port != null && !port.isEmpty()) {
                httpUrlBuilder.port(Integer.parseInt(port));
            }
            return httpUrlBuilder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to deserialize request messages", e);
        }
    }

    private CompletionEventSourceListener getEventSourceListener(final CompletionEventListener eventListener) {
        return new CompletionEventSourceListener(eventListener){

            @Override
            protected String getMessage(String data) {
                try {
                    List<YouSerpResult> serpResults;
                    YouCompletionResponse response = (YouCompletionResponse)new ObjectMapper().readValue(data, YouCompletionResponse.class);
                    if (eventListener instanceof YouCompletionEventListener && (serpResults = response.getSerpResults()) != null) {
                        ((YouCompletionEventListener)eventListener).onSerpResults(serpResults);
                    }
                    return response.getChatToken();
                }
                catch (JacksonException jacksonException) {
                    return "";
                }
            }

            @Override
            protected ErrorDetails getErrorDetails(String error) {
                return new ErrorDetails(error);
            }
        };
    }

    public static class Builder
    extends Client.Builder {
        private final String sessionId;
        private final String accessToken;

        public Builder(String sessionId, String accessToken) {
            this.sessionId = sessionId;
            this.accessToken = accessToken;
        }

        @Override
        public YouClient build() {
            return new YouClient(this);
        }
    }
}

