/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.mixin;

import ee.carlrobert.llm.client.http.LocalCallbackServer;
import ee.carlrobert.llm.client.http.Service;
import ee.carlrobert.llm.client.http.exchange.BasicHttpExchange;
import ee.carlrobert.llm.client.http.exchange.Exchange;
import ee.carlrobert.llm.client.http.exchange.StreamHttpExchange;
import ee.carlrobert.llm.client.http.expectation.BasicExpectation;
import ee.carlrobert.llm.client.http.expectation.StreamExpectation;
import ee.carlrobert.llm.client.mixin.ExternalService;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public interface ExternalServiceTestMixin {
    public static void init() {
        Private.externalServiceServerMap = Arrays.stream(ExternalService.values()).collect(Collectors.toMap(service -> service, service -> {
            LocalCallbackServer server = new LocalCallbackServer((Service)service);
            System.setProperty(service.getUrlProperty(), "http://localhost:" + server.getPort());
            return server;
        }));
    }

    public static void clearAll() {
        Private.externalServiceServerMap.values().forEach(LocalCallbackServer::clear);
    }

    default public void expectOpenAI(Exchange exchange) {
        this.addExpectation(ExternalService.OPENAI, exchange);
    }

    default public void expectAzure(Exchange exchange) {
        this.addExpectation(ExternalService.AZURE, exchange);
    }

    default public void expectYou(Exchange exchange) {
        this.addExpectation(ExternalService.YOU, exchange);
    }

    default public void expectLlama(Exchange exchange) {
        this.addExpectation(ExternalService.LLAMA, exchange);
    }

    private void addExpectation(ExternalService externalService, Exchange exchange) {
        Private.externalServiceServerMap.get(externalService).addExpectation(exchange instanceof BasicHttpExchange ? new BasicExpectation(externalService, (BasicHttpExchange)exchange) : new StreamExpectation(externalService, (StreamHttpExchange)exchange));
    }

    public static class Private {
        static Map<ExternalService, LocalCallbackServer> externalServiceServerMap;
    }
}

