/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.ollama;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.DeserializationUtil;
import ee.carlrobert.llm.client.InterceptorUtil;
import ee.carlrobert.llm.client.ollama.completion.request.OllamaCompletionRequest;
import ee.carlrobert.llm.client.ollama.completion.request.OllamaEmbeddingRequest;
import ee.carlrobert.llm.client.ollama.completion.request.OllamaPullRequest;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaCompletionResponse;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaEmbeddingResponse;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaModelInfoResponse;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaPullResponse;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaTagsResponse;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.completion.CompletionEventListener;
import ee.carlrobert.llm.completion.CompletionEventSourceListener;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSources;

public class OllamaClient {
    private static final String BASE_URL = PropertiesLoader.getValue("ollama.baseUrl");
    private final OkHttpClient httpClient;
    private final String host;
    private final Integer port;

    protected OllamaClient(Builder builder, OkHttpClient.Builder httpClientBuilder) {
        this.httpClient = httpClientBuilder.addInterceptor(InterceptorUtil.REWRITE_X_NDJSON_CONTENT_INTERCEPTOR).build();
        this.host = builder.host;
        this.port = builder.port;
    }

    public EventSource getChatCompletionAsync(OllamaCompletionRequest request, CompletionEventListener<String> eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildPostRequest(request, "/api/generate", true), this.getCompletionEventSourceListener(eventListener));
    }

    public OllamaCompletionResponse getChatCompletion(OllamaCompletionRequest request) {
        OllamaCompletionResponse ollamaCompletionResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildPostRequest(request, "/api/generate")).execute();
            try {
                ollamaCompletionResponse = DeserializationUtil.mapResponse(response, OllamaCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get ollama completion for the given request:\n" + request, e);
                }
            }
            response.close();
        }
        return ollamaCompletionResponse;
    }

    public OllamaEmbeddingResponse getEmbedding(OllamaEmbeddingRequest request) {
        OllamaEmbeddingResponse ollamaEmbeddingResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildPostRequest(request, "/api/embeddings")).execute();
            try {
                ollamaEmbeddingResponse = DeserializationUtil.mapResponse(response, OllamaEmbeddingResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get ollama embedding for the given request:\n" + request, e);
                }
            }
            response.close();
        }
        return ollamaEmbeddingResponse;
    }

    public OllamaPullResponse pullModel(OllamaPullRequest request) {
        OllamaPullResponse ollamaPullResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildPostRequest(request, "/api/pull")).execute();
            try {
                ollamaPullResponse = DeserializationUtil.mapResponse(response, OllamaPullResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not pull ollama model for the given request:\n" + request, e);
                }
            }
            response.close();
        }
        return ollamaPullResponse;
    }

    public EventSource pullModelAsync(OllamaPullRequest request, CompletionEventListener<OllamaPullResponse> eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildPostRequest(request, "/api/pull", true), this.getPullModelEventSourceListener(eventListener));
    }

    public boolean deleteModel(String model) {
        boolean bl;
        block8: {
            Response response = this.httpClient.newCall(this.defaultRequest("/api/delete").delete(OllamaClient.createRequestBody(Map.of("name", model))).build()).execute();
            try {
                bl = response.isSuccessful();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not delete ollama model for the given model name:\n" + model, e);
                }
            }
            response.close();
        }
        return bl;
    }

    public OllamaTagsResponse getModelTags() {
        OllamaTagsResponse ollamaTagsResponse;
        block8: {
            Response response = this.httpClient.newCall(this.defaultRequest("/api/tags").get().build()).execute();
            try {
                ollamaTagsResponse = DeserializationUtil.mapResponse(response, OllamaTagsResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get ollama model tags:\n", e);
                }
            }
            response.close();
        }
        return ollamaTagsResponse;
    }

    public OllamaModelInfoResponse getModelInfo(String model) {
        OllamaModelInfoResponse ollamaModelInfoResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildPostRequest(Map.of("name", model), "/api/show")).execute();
            try {
                ollamaModelInfoResponse = DeserializationUtil.mapResponse(response, OllamaModelInfoResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get ollama model info for the given model name:\n" + model, e);
                }
            }
            response.close();
        }
        return ollamaModelInfoResponse;
    }

    private Request buildPostRequest(Object request, String path) {
        return this.buildPostRequest(request, path, false);
    }

    private Request buildPostRequest(Object request, String path, boolean stream) {
        try {
            return this.defaultRequest(path, stream).post(OllamaClient.createRequestBody(request)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static RequestBody createRequestBody(Object request) throws JsonProcessingException {
        return RequestBody.create((String)new ObjectMapper().writeValueAsString(request), (MediaType)MediaType.parse((String)"application/json"));
    }

    private Request.Builder defaultRequest(String path) {
        return this.defaultRequest(path, false);
    }

    private Request.Builder defaultRequest(String path, boolean stream) {
        String baseHost = this.port == null ? BASE_URL : String.format("http://localhost:%d", this.port);
        return new Request.Builder().url((this.host == null ? baseHost : this.host) + path).header("Cache-Control", "no-cache").header("Content-Type", "application/json").header("Accept", stream ? "text/event-stream" : "text/json");
    }

    private CompletionEventSourceListener<String> getCompletionEventSourceListener(CompletionEventListener<String> eventListener) {
        return new CompletionEventSourceListener<String>(eventListener){

            @Override
            protected String getMessage(String data) {
                try {
                    return ((OllamaCompletionResponse)new ObjectMapper().readValue(data, OllamaCompletionResponse.class)).getResponse();
                }
                catch (JacksonException e) {
                    return "";
                }
            }

            @Override
            protected ErrorDetails getErrorDetails(String error) {
                return new ErrorDetails(error);
            }
        };
    }

    private CompletionEventSourceListener<OllamaPullResponse> getPullModelEventSourceListener(CompletionEventListener<OllamaPullResponse> eventListener) {
        return new CompletionEventSourceListener<OllamaPullResponse>(eventListener){

            @Override
            protected OllamaPullResponse getMessage(String data) {
                try {
                    return (OllamaPullResponse)new ObjectMapper().readValue(data, OllamaPullResponse.class);
                }
                catch (JacksonException e) {
                    return null;
                }
            }

            @Override
            protected ErrorDetails getErrorDetails(String error) {
                return new ErrorDetails(error);
            }
        };
    }

    public static class Builder {
        private String host;
        private Integer port;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public OllamaClient build(OkHttpClient.Builder builder) {
            return new OllamaClient(this, builder);
        }

        public OllamaClient build() {
            return this.build(new OkHttpClient.Builder());
        }
    }
}

