/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.anthropic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.DeserializationUtil;
import ee.carlrobert.llm.client.anthropic.completion.ClaudeCompletionErrorDetails;
import ee.carlrobert.llm.client.anthropic.completion.ClaudeCompletionRequest;
import ee.carlrobert.llm.client.anthropic.completion.ClaudeCompletionResponse;
import ee.carlrobert.llm.client.anthropic.completion.ClaudeCompletionStreamResponse;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.completion.CompletionEventListener;
import ee.carlrobert.llm.completion.CompletionEventSourceListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSources;

public class ClaudeClient {
    private static final String BASE_URL = PropertiesLoader.getValue("anthropic.baseUrl");
    private final OkHttpClient httpClient;
    private final String apiKey;
    private final String apiVersion;

    public ClaudeClient(String apiKey, String apiVersion, OkHttpClient.Builder httpClientBuilder) {
        this.httpClient = httpClientBuilder.build();
        this.apiKey = apiKey;
        this.apiVersion = apiVersion;
    }

    public EventSource getCompletionAsync(ClaudeCompletionRequest request, CompletionEventListener<String> eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildCompletionRequest(request), this.getCompletionEventSourceListener(eventListener));
    }

    public ClaudeCompletionResponse getCompletion(ClaudeCompletionRequest request) {
        ClaudeCompletionResponse claudeCompletionResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildCompletionRequest(request)).execute();
            try {
                claudeCompletionResponse = DeserializationUtil.mapResponse(response, ClaudeCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return claudeCompletionResponse;
    }

    protected Request buildCompletionRequest(ClaudeCompletionRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getRequiredHeaders());
        if (request.isStream()) {
            headers.put("Accept", "text/event-stream");
        }
        try {
            return new Request.Builder().url(BASE_URL + "/v1/messages").headers(Headers.of(headers)).post(RequestBody.create((String)new ObjectMapper().writeValueAsString((Object)request), (MediaType)MediaType.parse((String)"application/json"))).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Map<String, String> getRequiredHeaders() {
        return new HashMap<String, String>(Map.of("x-api-key", this.apiKey, "anthropic-version", this.apiVersion));
    }

    private CompletionEventSourceListener<String> getCompletionEventSourceListener(CompletionEventListener<String> eventListener) {
        return new CompletionEventSourceListener<String>(eventListener){

            @Override
            protected String getMessage(String data) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    return ((ClaudeCompletionStreamResponse)mapper.readValue(data, ClaudeCompletionStreamResponse.class)).getDelta().getText();
                }
                catch (Exception e) {
                    try {
                        return ((ClaudeCompletionErrorDetails)mapper.readValue(data, ClaudeCompletionErrorDetails.class)).getError().getMessage();
                    }
                    catch (Exception ex) {
                        return "";
                    }
                }
            }

            @Override
            protected ErrorDetails getErrorDetails(String error) {
                try {
                    return ((ClaudeCompletionErrorDetails)new ObjectMapper().readValue(error, ClaudeCompletionErrorDetails.class)).getError();
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

