/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.openai;

import com.fasterxml.jackson.core.JsonProcessingException;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.DeserializationUtil;
import ee.carlrobert.llm.client.openai.completion.OpenAIChatCompletionEventSourceListener;
import ee.carlrobert.llm.client.openai.completion.OpenAITextCompletionEventSourceListener;
import ee.carlrobert.llm.client.openai.completion.request.OpenAIChatCompletionRequest;
import ee.carlrobert.llm.client.openai.completion.request.OpenAITextCompletionRequest;
import ee.carlrobert.llm.client.openai.completion.response.OpenAIChatCompletionResponse;
import ee.carlrobert.llm.client.openai.embeddings.EmbeddingData;
import ee.carlrobert.llm.client.openai.embeddings.EmbeddingResponse;
import ee.carlrobert.llm.completion.CompletionEventListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class OpenAIClient {
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    private final OkHttpClient httpClient;
    private final String apiKey;
    private final String organization;
    private final String host;

    private OpenAIClient(Builder builder, OkHttpClient.Builder httpClientBuilder) {
        this.httpClient = httpClientBuilder.build();
        this.apiKey = builder.apiKey;
        this.organization = builder.organization;
        this.host = builder.host;
    }

    public EventSource getCompletionAsync(OpenAITextCompletionRequest request, CompletionEventListener<String> eventListener) {
        return this.getCompletionAsync(request, new OpenAITextCompletionEventSourceListener((CompletionEventListener)eventListener));
    }

    public EventSource getCompletionAsync(OpenAITextCompletionRequest request, OpenAITextCompletionEventSourceListener eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildTextCompletionRequest(request), (EventSourceListener)eventListener);
    }

    public EventSource getChatCompletionAsync(OpenAIChatCompletionRequest request, CompletionEventListener<String> eventListener) {
        return this.getChatCompletionAsync(request, new OpenAIChatCompletionEventSourceListener(eventListener));
    }

    public EventSource getChatCompletionAsync(OpenAIChatCompletionRequest request, OpenAIChatCompletionEventSourceListener eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildChatCompletionRequest(request), (EventSourceListener)eventListener);
    }

    public OpenAIChatCompletionResponse getChatCompletion(OpenAIChatCompletionRequest request) {
        OpenAIChatCompletionResponse openAIChatCompletionResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildChatCompletionRequest(request)).execute();
            try {
                openAIChatCompletionResponse = DeserializationUtil.mapResponse(response, OpenAIChatCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return openAIChatCompletionResponse;
    }

    public double[] getEmbedding(String input) {
        List<double[]> embeddings = this.getEmbeddings(List.of(input));
        return embeddings.isEmpty() ? null : embeddings.get(0);
    }

    public List<double[]> getEmbeddings(List<String> texts) {
        List<double[]> list;
        block8: {
            Response response = this.httpClient.newCall(this.buildEmbeddingsRequest(this.host + "/v1/embeddings", texts)).execute();
            try {
                list = Optional.ofNullable(DeserializationUtil.mapResponse(response, EmbeddingResponse.class)).map(EmbeddingResponse::getData).stream().flatMap(Collection::stream).filter(Objects::nonNull).map(EmbeddingData::getEmbedding).filter(Objects::nonNull).collect(Collectors.toList());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to fetch embedding", e);
                }
            }
            response.close();
        }
        return list;
    }

    private Request buildEmbeddingsRequest(String url, List<String> texts) throws JsonProcessingException {
        return new Request.Builder().url(url).headers(Headers.of(this.getRequiredHeaders())).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString(Map.of("input", texts, "model", "text-embedding-ada-002")), (MediaType)APPLICATION_JSON)).build();
    }

    private Request buildChatCompletionRequest(OpenAIChatCompletionRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getRequiredHeaders());
        if (request.isStream()) {
            headers.put("Accept", "text/event-stream");
        }
        try {
            String overriddenPath = request.getOverriddenPath();
            return new Request.Builder().url(this.host + (overriddenPath == null ? "/v1/chat/completions" : overriddenPath)).headers(Headers.of(headers)).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Request buildTextCompletionRequest(OpenAITextCompletionRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getRequiredHeaders());
        if (request.isStream()) {
            headers.put("Accept", "text/event-stream");
        }
        try {
            return new Request.Builder().url(this.host + "/v1/completions").headers(Headers.of(headers)).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Map<String, String> getRequiredHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(Map.of("X-LLM-Application-Tag", "codegpt"));
        if (this.apiKey != null && !this.apiKey.isEmpty()) {
            headers.put("Authorization", "Bearer " + this.apiKey);
        }
        if (this.organization != null && !this.organization.isEmpty()) {
            headers.put("OpenAI-Organization", this.organization);
        }
        return headers;
    }

    public static class Builder {
        private final String apiKey;
        private String host = PropertiesLoader.getValue("openai.baseUrl");
        private String organization;

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OpenAIClient build(OkHttpClient.Builder builder) {
            return new OpenAIClient(this, builder);
        }

        public OpenAIClient build() {
            return this.build(new OkHttpClient.Builder());
        }
    }
}

