/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import ee.carlrobert.llm.client.DeserializationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONUtil {
    @SafeVarargs
    public static String jsonMapResponse(Map.Entry<String, ?> ... entries) {
        try {
            return DeserializationUtil.OBJECT_MAPPER.writeValueAsString(Map.ofEntries(entries));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to map to json string", e);
        }
    }

    public static String jsonMapResponse(String key, Object value) {
        if (value == null) {
            return String.format("{\"%s\": null}", key);
        }
        return JSONUtil.jsonMapResponse(JSONUtil.e(key, value));
    }

    @SafeVarargs
    public static Map<String, ?> jsonMap(Map.Entry<String, ?> ... entries) {
        return Map.ofEntries(entries);
    }

    public static Map<String, ?> jsonMap(String key, Object value) {
        if (value == null) {
            HashMap<String, Object> contentNull = new HashMap<String, Object>();
            contentNull.put(key, null);
            return contentNull;
        }
        return JSONUtil.jsonMap(JSONUtil.e(key, value));
    }

    @SafeVarargs
    public static List<?> jsonArray(Map<String, ?> ... objects) {
        ArrayList list = new ArrayList();
        if (objects == null) {
            list.add(null);
        } else {
            for (int i = 0; i < objects.length; ++i) {
                list.add(objects[i]);
            }
        }
        return list;
    }

    public static Map.Entry<String, ?> e(String key, Object value) {
        return Map.entry(key, value);
    }
}

